/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.experiments.FixedTestSetSplitter;
import edu.cmu.minorthird.classify.experiments.Tester;
import edu.cmu.minorthird.classify.multi.MultiCrossValidatedDataset;
import edu.cmu.minorthird.classify.multi.MultiDataset;
import edu.cmu.minorthird.classify.multi.MultiEvaluation;
import edu.cmu.minorthird.classify.multi.MultiExample;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;
import java.io.Serializable;

public class TrainTestMultiClassifier
extends UIMain {
    protected CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    protected CommandLineUtil.MultiClassificationSignalParams signal = new CommandLineUtil.MultiClassificationSignalParams(this.base);
    protected CommandLineUtil.TrainClassifierParams train = new CommandLineUtil.TrainClassifierParams();
    protected CommandLineUtil.SplitterParams trainTest = new CommandLineUtil.SplitterParams();
    protected Object result = null;

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams base) {
        this.save = base;
    }

    public CommandLineUtil.MultiClassificationSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.MultiClassificationSignalParams base) {
        this.signal = base;
    }

    public CommandLineUtil.TrainClassifierParams getTrainingParameters() {
        return this.train;
    }

    public void setTrainingParameters(CommandLineUtil.TrainClassifierParams train) {
        this.train = train;
    }

    public CommandLineUtil.SplitterParams getSplitterParameters() {
        return this.trainTest;
    }

    public void setSplitterParameters(CommandLineUtil.SplitterParams trainTest) {
        this.trainTest = trainTest;
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.train, this.trainTest});
    }

    public void doMain() {
        if (this.train.learner == null) {
            throw new IllegalArgumentException("-learner must be specified");
        }
        if (this.signal.multiSpanProp == null) {
            throw new IllegalArgumentException("-multiSpanProp  must be specified");
        }
        MultiDataset d = CommandLineUtil.toMultiDataset(this.base.labels, this.train.fe, this.signal.multiSpanProp);
        if (this.train.showData) {
            new ViewerFrame("Dataset", d.toGUI());
        }
        if (this.trainTest.labels != null) {
            MultiDataset testData = CommandLineUtil.toMultiDataset(this.trainTest.labels, this.train.fe, this.signal.multiSpanProp);
            this.trainTest.splitter = new FixedTestSetSplitter<MultiExample>(testData.multiIterator());
        }
        MultiCrossValidatedDataset cvd = null;
        MultiEvaluation evaluation = null;
        if (this.trainTest.showTestDetails) {
            cvd = new MultiCrossValidatedDataset(this.train.learner, d, this.trainTest.splitter, false, this.signal.cross);
            evaluation = cvd.getEvaluation();
            this.result = cvd;
        } else {
            cvd = null;
            evaluation = Tester.multiEvaluate(this.train.learner, d, this.trainTest.splitter, this.signal.cross);
            this.result = evaluation;
        }
        if (this.base.showResult) {
            new ViewerFrame("Result", new SmartVanillaViewer(this.result));
        }
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized((Serializable)((Object)evaluation), this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
        evaluation.summarize();
    }

    public Object getMainResult() {
        return this.result;
    }

    public static void main(String[] args) {
        new TrainTestMultiClassifier().callMain(args);
    }
}

