/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextBaseLoader;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineProcessingUtil {
    public static boolean lineMatcher(String patternStr, String tmpstr) {
        int strsize = tmpstr.length();
        CharSequence tmp = tmpstr.subSequence(0, strsize);
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(tmp);
        return matcher.find();
    }

    public static void addFeature(String line, String regexp, String featureName, StringBuffer features_out) {
        if (LineProcessingUtil.lineMatcher(regexp, line)) {
            features_out.append(" " + featureName + "=1");
        }
    }

    public static double punctuationPercentage(String line) {
        int linelength = line.length();
        if (linelength == 0) {
            return 0.0;
        }
        int punctCount = 0;
        for (int i = 0; i < linelength; ++i) {
            if (!LineProcessingUtil.lineMatcher("\\p{Punct}", line.substring(i, i + 1))) continue;
            ++punctCount;
        }
        double perc = (double)punctCount / (double)linelength;
        return perc;
    }

    public static double AtoZPercentage(String line) {
        int linelength = line.length();
        if (linelength == 0) {
            return 0.0;
        }
        int punctCount = 0;
        for (int i = 0; i < linelength; ++i) {
            if (!LineProcessingUtil.lineMatcher("a-zA-Z", line.substring(i, i + 1))) continue;
            ++punctCount;
        }
        double perc = (double)punctCount / (double)linelength;
        return perc;
    }

    public static double wordCharactersPercentage(String line) {
        int linelength = line.length();
        if (linelength == 0) {
            return 0.0;
        }
        int punctCount = 0;
        for (int i = 0; i < linelength; ++i) {
            if (!LineProcessingUtil.lineMatcher("\\w", line.substring(i, i + 1))) continue;
            ++punctCount;
        }
        double perc = (double)punctCount / (double)linelength;
        return perc;
    }

    public static double indentPercentage(String line) {
        int linelength = line.length();
        if (linelength == 0) {
            return 0.0;
        }
        int punctCount = 0;
        for (int i = 0; i < linelength; ++i) {
            if (!LineProcessingUtil.lineMatcher("\\t", line.substring(i, i + 1))) continue;
            ++punctCount;
        }
        double perc = (double)punctCount / (double)linelength;
        return perc;
    }

    public static int indentNumber(String line) {
        int linelength = line.length();
        if (linelength == 0) {
            return 0;
        }
        int punctCount = 0;
        for (int i = 0; i < linelength; ++i) {
            if (!LineProcessingUtil.lineMatcher("\\t", line.substring(i, i + 1))) continue;
            ++punctCount;
        }
        return punctCount;
    }

    public static int numberOfMatches(String expression, String line) {
        int linelength = line.length();
        int exprelength = expression.length();
        if (linelength == 0 || exprelength == 0) {
            return 0;
        }
        int theCount = 0;
        for (int i = 0; i < linelength - exprelength; ++i) {
            if (!LineProcessingUtil.lineMatcher(expression, line.substring(i, i + exprelength))) continue;
            ++theCount;
            i += exprelength;
        }
        return theCount;
    }

    public static boolean startWithSameInitialPunctCharacters(String tmp, String tmp1) {
        String ind2;
        String ind;
        return tmp.length() > 0 && tmp1.length() > 0 && LineProcessingUtil.lineMatcher("\\p{Punct}", ind = tmp.substring(0, 1)) && (ind2 = tmp1.substring(0, 1)).compareTo(ind) == 0;
    }

    public static String[] getMessageLines(String tmp) {
        String[] outL = tmp.split("\n");
        return outL;
    }

    public static String readFile(String in) throws IOException {
        String line = null;
        StringBuffer content = new StringBuffer("");
        BufferedReader bReader = new BufferedReader(new FileReader(in));
        while ((line = bReader.readLine()) != null) {
            content.append(line + "\n");
        }
        bReader.close();
        return content.toString();
    }

    public static void writeToOutputFile(String outputFileName, StringBuffer aux) throws IOException {
        BufferedWriter bWriter = new BufferedWriter(new FileWriter(outputFileName));
        bWriter.write(aux.toString());
        bWriter.close();
    }

    public static TextLabels readBsh(File dir, File envfile) throws Exception {
        System.out.println("reading data files");
        TextBaseLoader tbl = new TextBaseLoader(1, true);
        tbl.load(dir);
        MutableTextLabels lala = tbl.getLabels();
        TextBase basevitor = lala.getTextBase();
        TextLabelsLoader labelLoaderVitor = new TextLabelsLoader();
        System.out.println("reading env file...");
        labelLoaderVitor.importOps(lala, basevitor, envfile);
        return lala;
    }
}

