/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

public class StringUtil {
    public static String lineWrap(String s, int lineLength) {
        StringBuffer buf = new StringBuffer("");
        int lastLF = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isWhitespace(ch) && i - lastLF >= lineLength) {
                buf.append('\n');
                lastLF = i;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String indent(int tabs, String s) {
        StringBuffer tabbuf = new StringBuffer();
        for (int i = 0; i < tabs; ++i) {
            tabbuf.append("|  ");
        }
        String tab = tabbuf.toString();
        return tab + s.replaceAll("\\n", "\n" + tab);
    }

    public static String toString(Object[] x) {
        return StringUtil.toString(x, "[", "]", ",");
    }

    public static String toString(double[] x) {
        return StringUtil.toString(x, "[", "]", ",");
    }

    public static String toString(int[] x) {
        return StringUtil.toString(x, "[", "]", ",");
    }

    public static String toString(Object[] x, String prefix, String suffix, String sep) {
        StringBuffer buf = new StringBuffer("");
        buf.append(prefix);
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                buf.append(sep);
            }
            if (x[i] == null) {
                buf.append("null");
                continue;
            }
            buf.append(x[i].toString());
        }
        buf.append(suffix);
        return buf.toString();
    }

    public static String toString(double[] x, String prefix, String suffix, String sep) {
        StringBuffer buf = new StringBuffer("");
        buf.append(prefix);
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                buf.append(sep);
            }
            buf.append(Double.toString(x[i]));
        }
        buf.append(suffix);
        return buf.toString();
    }

    public static String toString(int[] x, String prefix, String suffix, String sep) {
        StringBuffer buf = new StringBuffer("");
        buf.append(prefix);
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                buf.append(sep);
            }
            buf.append(Integer.toString(x[i]));
        }
        buf.append(suffix);
        return buf.toString();
    }

    public static int atoi(String intName) {
        try {
            return Integer.parseInt(intName);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("illegal integer '" + intName + "'");
        }
    }

    public static double atof(String doubleName) {
        try {
            return Double.parseDouble(doubleName);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("illegal double '" + doubleName + "'");
        }
    }

    public static String truncate(int len, String s) {
        if (len >= s.length()) {
            return s;
        }
        return s.substring(0, len) + "...";
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.lineWrap(args[0], StringUtil.atoi(args[1])));
    }
}

