/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import java.awt.Font;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Console {
    private PipedInputStream piOut;
    private PipedOutputStream poOut;
    private JTextArea errorArea = new JTextArea(20, 100);
    private JScrollPane scroller;
    private Thread mainThread;
    private Thread readerThread;
    private boolean doMainRunning;
    private PrintStream oldSystemOut;
    private JButton viewButton;
    private Object task;

    public Console(Task t) {
        this.errorArea.setFont(new Font("monospaced", 0, 12));
        this.scroller = new JScrollPane(this.errorArea);
        this.task = t;
    }

    public Console(Object t, boolean l, JButton vb) {
        this.errorArea.setFont(new Font("monospaced", 0, 12));
        this.scroller = new JScrollPane(this.errorArea);
        this.task = t;
        this.viewButton = vb;
    }

    public JComponent getMainComponent() {
        return this.scroller;
    }

    public void start() {
        this.initThreads();
        try {
            this.oldSystemOut = System.out;
            this.piOut = new PipedInputStream();
            this.poOut = new PipedOutputStream(this.piOut);
            System.setOut(new PrintStream(this.poOut, true));
        }
        catch (IOException io) {
            this.errorArea.append("Couldn't redirect output\n" + io.getMessage() + "\n");
        }
        catch (SecurityException se) {
            this.errorArea.append("SE error" + se.getMessage() + "\n");
        }
        this.mainThread.start();
    }

    public void append(String s) {
        this.errorArea.append(s);
        this.scrollDown();
    }

    public void clear() {
        this.errorArea.setText("");
    }

    private void initThreads() {
        this.mainThread = new Thread(){

            public void run() {
                if (Console.this.task instanceof Task) {
                    Console.this.viewButton.setEnabled(false);
                    if (!((Task)Console.this.task).getLabels()) {
                        Console.this.errorArea.append("\nYou need to specify the labeled data you're using!\nModify the 'labels' parameters under base parameters section\nof the parameter modification window.\n");
                    } else {
                        long startTime = System.currentTimeMillis();
                        Console.this.doMainRunning = true;
                        Console.this.readerThread.start();
                        ((Task)Console.this.task).doMain();
                        double elapsedTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                        System.out.println("\nTotal time for task: " + elapsedTime + " sec");
                        Console.this.viewButton.setEnabled(((Task)Console.this.task).getMainResult() != null);
                        Console.this.doMainRunning = false;
                        try {
                            Console.this.readerThread.join();
                        }
                        catch (InterruptedException ex) {
                            System.err.println("reader interrupted?");
                        }
                        Console.this.scrollDown();
                    }
                } else {
                    Console.this.errorArea.append("Error: Task is not an instance of Console.Task \n");
                }
            }
        };
        this.readerThread = new Thread(){

            public void run() {
                try {
                    byte[] buf = new byte[2048];
                    int len = 0;
                    while (Console.this.doMainRunning) {
                        len = Console.this.piOut.read(buf);
                        if (len > 0) {
                            Console.this.errorArea.append(new String(buf, 0, len));
                            Console.this.scrollDown();
                        }
                        2.yield();
                    }
                    len = Console.this.piOut.read(buf);
                    if (len > 0) {
                        Console.this.errorArea.append(new String(buf, 0, len));
                        Console.this.scrollDown();
                    }
                    Console.this.closePipes();
                }
                catch (IOException e) {
                    Console.this.errorArea.append(e.getMessage());
                    System.out.println(e.getMessage());
                }
            }
        };
    }

    private void scrollDown() {
        try {
            JScrollBar bar = this.scroller.getVerticalScrollBar();
            bar.setValue(bar.getMaximum());
        }
        catch (Exception ex) {
            System.err.println("error scrolling: " + ex);
        }
    }

    private void closePipes() {
        try {
            this.poOut.close();
            this.piOut.close();
            System.setOut(this.oldSystemOut);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static interface Task {
        public boolean getLabels();

        public void doMain();

        public Object getMainResult();
    }
}

