/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.TransformedVanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlledViewer
extends Viewer {
    static final long serialVersionUID = 20080517L;
    private Viewer viewer = null;
    private ViewerControls controls = null;

    public ControlledViewer() {
    }

    public ControlledViewer(Viewer viewer, ViewerControls controls) {
        this.setComponents(viewer, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setComponents(Viewer viewer, ViewerControls controls) {
        if (!(viewer instanceof Controllable)) {
            throw new IllegalArgumentException("viewer must be controllable");
        }
        this.controls = controls;
        this.viewer = viewer;
        controls.setControlledViewer(viewer);
        viewer.setSuperView(this);
        this.removeAll();
        if (controls.prefersToBeResized()) {
            if (controls.preferredLocation() == 1) {
                JSplitPane splitPane = new JSplitPane(0);
                splitPane.setResizeWeight(0.9);
                splitPane.setTopComponent(viewer);
                splitPane.setBottomComponent(controls);
                this.add((Component)splitPane, ControlledViewer.fillerGBC());
                return;
            } else if (controls.preferredLocation() == 3) {
                JSplitPane splitPane = new JSplitPane(0);
                splitPane.setResizeWeight(0.1);
                splitPane.setTopComponent(controls);
                splitPane.setBottomComponent(viewer);
                this.add((Component)splitPane, ControlledViewer.fillerGBC());
                return;
            } else if (controls.preferredLocation() == 2) {
                JSplitPane splitPane = new JSplitPane(1);
                splitPane.setResizeWeight(0.75);
                splitPane.setLeftComponent(viewer);
                splitPane.setRightComponent(controls);
                this.add((Component)splitPane, ControlledViewer.fillerGBC());
                return;
            } else {
                if (controls.preferredLocation() != 4) throw new IllegalArgumentException("controls has illegal preferred location " + controls.preferredLocation() + ": " + controls);
                JSplitPane splitPane = new JSplitPane(1);
                splitPane.setResizeWeight(0.25);
                splitPane.setLeftComponent(controls);
                splitPane.setRightComponent(viewer);
                this.add((Component)splitPane, ControlledViewer.fillerGBC());
            }
            return;
        } else {
            int part;
            int y2;
            int x2;
            int y1;
            int x1;
            int loc = controls.preferredLocation();
            if (loc == 1) {
                x1 = 0;
                y1 = 0;
                x2 = 0;
                y2 = 1;
                part = 10;
            } else if (loc == 3) {
                x1 = 0;
                y1 = 1;
                x2 = 0;
                y2 = 0;
                part = 9;
            } else if (loc == 2) {
                x1 = 0;
                y1 = 0;
                x2 = 1;
                y2 = 0;
                part = 4;
            } else {
                if (loc != 4) throw new IllegalArgumentException("controls has illegal preferred location " + loc + ": " + controls);
                x1 = 1;
                y1 = 0;
                x2 = 0;
                y2 = 0;
                part = 1;
            }
            GridBagConstraints gbc = ControlledViewer.fillerGBC();
            gbc.gridx = x1;
            gbc.gridy = y1;
            this.add((Component)viewer, gbc);
            gbc = ControlledViewer.fillerGBC();
            gbc.gridx = x2;
            gbc.gridy = y2;
            gbc.weightx /= (double)part;
            gbc.weighty /= (double)part;
            this.add((Component)controls, gbc);
        }
    }

    public ViewerControls getControls() {
        return this.controls;
    }

    @Override
    protected void initialize() {
        this.setLayout(new GridBagLayout());
    }

    @Override
    public void clearContent() {
        this.viewer.clearContent();
    }

    @Override
    public boolean canReceive(Object obj) {
        return this.viewer.canReceive(obj);
    }

    @Override
    public void receiveContent(Object obj) {
        this.viewer.setContent(obj);
    }

    @Override
    protected boolean canHandle(int signal, Object argument, List<Viewer> senders) {
        return this.viewer.canHandle(signal, argument, senders);
    }

    @Override
    protected void handle(int signal, Object argument, List<Viewer> senders) {
        this.viewer.handle(signal, argument, senders);
    }

    public static void main(String[] argv) {
        ControlledViewer v = new ControlledViewer(new MyViewer(), new MyControls());
        v.setContent("William Cohen");
        new ViewerFrame("test", v);
    }

    private static class MyControls
    extends ViewerControls {
        static final long serialVersionUID = 20080517L;
        public JCheckBox ucBox;
        public JTextField prefixField;

        private MyControls() {
        }

        public void initialize() {
            this.ucBox = new JCheckBox("uc");
            this.ucBox.addActionListener(this);
            this.add(this.ucBox);
            this.prefixField = new JTextField("the man: ");
            this.add(this.prefixField);
            this.addApplyButton();
        }

        public String toString() {
            return "[uc: " + this.ucBox.isSelected() + " prefix: " + this.prefixField.getText() + "]";
        }
    }

    private static class MyViewer
    extends TransformedVanillaViewer
    implements Controllable {
        static final long serialVersionUID = 20080517L;
        private boolean uc;
        private String prefix;
        private Object lastObj;

        private MyViewer() {
        }

        public Object transform(Object o) {
            String result;
            this.lastObj = o;
            String s = o.toString();
            String string2 = result = this.uc ? s.toUpperCase() : s;
            if (this.prefix != null) {
                result = this.prefix + result;
            }
            System.out.println("transform: " + o + " => " + result);
            return result;
        }

        public void applyControls(ViewerControls c) {
            System.out.println("controls: " + c);
            MyControls mc = (MyControls)c;
            this.uc = mc.ucBox.isSelected();
            this.prefix = mc.prefixField.getText();
            System.out.println("recieving: " + this.lastObj + " with uc=" + this.uc + " prefix=" + this.prefix);
            this.receiveContent(this.lastObj);
            this.revalidate();
        }
    }
}

