/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class LineCharter {
    private XYSeriesCollection collection = new XYSeriesCollection();
    private XYSeries currentSeries = null;
    private int numPoints = 0;
    private StringBuffer buf = new StringBuffer("");

    public void startCurve(String label) {
        if (this.currentSeries != null) {
            this.collection.addSeries(this.currentSeries);
            this.buf.append("\n");
        }
        this.buf.append("#begin " + label + "\n");
        this.currentSeries = new XYSeries(label);
        this.numPoints = 0;
    }

    public void addPoint(double x, double y, boolean mayDuplicate) {
        if (this.currentSeries == null) {
            throw new IllegalStateException("need to start series before adding points");
        }
        if (mayDuplicate) {
            this.currentSeries.add(x + 1.0E-5 * (double)this.numPoints, y);
        } else {
            this.currentSeries.add(x, y);
        }
        ++this.numPoints;
        this.buf.append(x + "\t" + y + "\n");
    }

    public void addPoint(double x, double y) {
        this.addPoint(x, y, true);
    }

    public JPanel getPanel(String title, String xlabel, String ylabel) {
        if (this.currentSeries != null) {
            this.collection.addSeries(this.currentSeries);
        }
        JPanel mainPanel = new JPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        JFreeChart chart = ChartFactory.createXYLineChart(title, xlabel, ylabel, this.collection, PlotOrientation.VERTICAL, true, true, false);
        tabbedPane.add("Graphics", new ChartPanel(chart));
        tabbedPane.add("Text", new JScrollPane(new JTextArea("#" + xlabel + "\t" + ylabel + "\n" + this.buf.toString(), 20, 30)));
        mainPanel.add(tabbedPane);
        return mainPanel;
    }
}

