/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.IntDoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import iitb.CRF.RobustMath;
import java.util.TreeSet;

public class LogDenseDoubleMatrix1D
extends DenseDoubleMatrix1D {
    static double map(double val) {
        if (val == RobustMath.LOG0) {
            return 0.0;
        }
        if (val == 0.0) {
            return Double.MIN_VALUE;
        }
        return val;
    }

    static double reverseMap(double val) {
        if (val == 0.0) {
            return RobustMath.LOG0;
        }
        if (val == Double.MIN_VALUE) {
            return 0.0;
        }
        return val;
    }

    public LogDenseDoubleMatrix1D(int numY) {
        super(numY);
    }

    public DoubleMatrix1D assign(double val) {
        return super.assign(LogDenseDoubleMatrix1D.map(val));
    }

    public void set(int row, double val) {
        super.set(row, LogDenseDoubleMatrix1D.map(val));
    }

    public double get(int row) {
        return LogDenseDoubleMatrix1D.reverseMap(super.get(row));
    }

    public double zSum() {
        TreeSet logProbVector = new TreeSet();
        for (int row = 0; row < this.size(); ++row) {
            if (this.getQuick(row) == 0.0) continue;
            RobustMath.addNoDups(logProbVector, this.get(row));
        }
        return RobustMath.logSumExp(logProbVector);
    }

    public DoubleMatrix1D forEachNonZero(IntDoubleFunction func) {
        for (int y = 0; y < this.size(); ++y) {
            if (this.getQuick(y) == 0.0) continue;
            this.setQuick(y, func.apply(y, this.get(y)));
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D v2, DoubleDoubleFunction func) {
        for (int row = 0; row < this.size(); ++row) {
            if (v2.getQuick(row) == 0.0 && this.getQuick(row) == 0.0) continue;
            this.set(row, func.apply(this.get(row), v2.get(row)));
        }
        return this;
    }

    public boolean equals(Object arg) {
        DoubleMatrix1D mat = (DoubleMatrix1D)arg;
        for (int row = this.size() - 1; row >= 0; --row) {
            if (!(Math.abs(mat.get(row) - this.get(row)) / Math.abs(mat.get(row)) > 1.0E-4)) continue;
            return false;
        }
        return true;
    }
}

