/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import iitb.CRF.DataSequence;
import iitb.CRF.NestedCRF;
import iitb.CRF.SegmentDataSequence;
import iitb.CRF.Soln;
import iitb.CRF.Trainer;
import iitb.CRF.Viterbi;

public class NestedViterbi
extends Viterbi {
    NestedCRF nestedModel;

    NestedViterbi(NestedCRF nestedModel, int bs) {
        super(nestedModel, bs);
        this.nestedModel = nestedModel;
    }

    double fillArray(DataSequence dataSeq, double[] lambda, boolean calcScore) {
        int numY = this.model.numY;
        int maxLen = this.nestedModel.featureGenNested.maxMemory();
        for (int i = 0; i < dataSeq.length(); ++i) {
            int yi = 0;
            while (yi < numY) {
                this.winningLabel[yi++][i].clear();
            }
            for (int ell = 1; ell <= maxLen && i - ell >= -1; ++ell) {
                this.nestedModel.featureGenNested.startScanFeaturesAt(dataSeq, i - ell, i);
                Trainer.computeLogMi(this.model.featureGenerator, lambda, this.Mi, this.Ri, false);
                for (int yi2 = 0; yi2 < numY; ++yi2) {
                    if (i - ell < 0) {
                        this.winningLabel[yi2][i].add((float)this.Ri.get(yi2));
                        continue;
                    }
                    for (int yp = 0; yp < numY; ++yp) {
                        double val = this.Mi.get(yp, yi2) + this.Ri.get(yi2);
                        this.winningLabel[yi2][i].add(this.winningLabel[yp][i - ell], (float)val);
                    }
                }
            }
        }
        return 0.0;
    }

    public void bestLabelSequence(SegmentDataSequence dataSeq, double[] lambda) {
        this.viterbiSearch(dataSeq, lambda, false);
        Soln ybest = this.finalSoln.get(0);
        ybest = ybest.prevSoln;
        while (ybest != null) {
            dataSeq.setSegment(ybest.prevPos() + 1, ybest.pos, ybest.label);
            ybest = ybest.prevSoln;
        }
    }
}

