/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import gnu.trove.TIntArrayList;
import gnu.trove.TIntFloatHashMap;
import iitb.CRF.CRF;
import iitb.CRF.CandSegDataSequence;
import iitb.CRF.FeatureGenerator;
import iitb.CRF.FeatureGeneratorNested;
import iitb.CRF.NestedCollinsTrainer;
import iitb.CRF.SegmentTrainer;
import iitb.CRF.SegmentViterbi;
import iitb.CRF.Segmentation;
import iitb.CRF.Trainer;
import iitb.CRF.Viterbi;
import java.util.Properties;

public class SegmentCRF
extends CRF {
    FeatureGeneratorNested featureGenNested;
    transient SegmentViterbi segmentViterbi;

    public SegmentCRF(int numLabels, FeatureGeneratorNested fgen, String arg) {
        super(numLabels, (FeatureGenerator)fgen, arg);
        this.featureGenNested = fgen;
        this.segmentViterbi = new SegmentViterbi(this, 1);
    }

    public SegmentCRF(int numLabels, FeatureGeneratorNested fgen, Properties configOptions) {
        super(numLabels, (FeatureGenerator)fgen, configOptions);
        this.featureGenNested = fgen;
        this.segmentViterbi = new SegmentViterbi(this, 1);
    }

    protected Trainer getTrainer() {
        if (this.params.trainerType.startsWith("SegmentCollins")) {
            return new NestedCollinsTrainer(this.params);
        }
        return new SegmentTrainer(this.params);
    }

    protected Viterbi getViterbi(int beamsize) {
        return new SegmentViterbi(this, beamsize);
    }

    public void apply(CandSegDataSequence dataSeq, int rank) {
        if (this.segmentViterbi == null) {
            this.segmentViterbi = (SegmentViterbi)this.getViterbi(1);
        }
        this.segmentViterbi.bestLabelSequence(dataSeq, this.lambda);
    }

    public void singleSegmentClassScores(CandSegDataSequence dataSeq, TIntFloatHashMap scores) {
        if (this.segmentViterbi == null) {
            this.segmentViterbi = (SegmentViterbi)this.getViterbi(1);
        }
        this.segmentViterbi.singleSegmentClassScores(dataSeq, this.lambda, scores);
    }

    public Segmentation[] segmentSequences(CandSegDataSequence dataSeq, int numLabelSeqs) {
        if (this.segmentViterbi == null) {
            this.segmentViterbi = (SegmentViterbi)this.getViterbi(numLabelSeqs);
        }
        return this.segmentViterbi.segmentSequences(dataSeq, this.lambda, numLabelSeqs);
    }

    public static interface ModelGraph {
        public int numStates();

        public void stateMappingGivenLength(int var1, int var2, TIntArrayList var3) throws Exception;
    }
}

