/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.Edge;
import iitb.Model.EdgeIterator;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;

public class EdgeFeatures
extends FeatureTypes {
    protected transient EdgeIterator edgeIter = null;
    protected int edgeNum;
    transient boolean edgeIsOuter;
    Object[] labelNames;

    public EdgeFeatures(FeatureGenImpl m, Object[] labels) {
        super(m);
        this.labelNames = labels;
    }

    public EdgeFeatures(FeatureGenImpl m) {
        this(m, null);
    }

    protected void setEdgeIter() {
        this.edgeIter = this.model.edgeIterator();
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        if (prevPos < 0) {
            this.edgeNum = this.model.numEdges();
            return false;
        }
        this.edgeNum = 0;
        if (this.edgeIter == null) {
            this.setEdgeIter();
        }
        if (this.edgeIter != null) {
            this.edgeIter.start();
        }
        return this.hasNext();
    }

    public boolean hasNext() {
        return this.edgeIter != null && this.edgeNum < this.model.numEdges();
    }

    public boolean lastEdgeWasOuter() {
        return this.edgeIsOuter;
    }

    public void next(FeatureImpl f) {
        this.edgeIsOuter = this.edgeIter.nextIsOuter();
        Edge e = this.edgeIter.next();
        Object name = "";
        if (this.featureCollectMode()) {
            name = this.labelNames == null ? "E." + this.model.label(e.start) : this.labelNames[this.model.label(e.start)];
        }
        if (this.edgeIsOuter) {
            this.setFeatureIdentifier(this.model.label(e.start) * this.model.numberOfLabels() + this.model.label(e.end) + this.model.numEdges(), this.model.label(e.end), name, f);
        } else {
            this.setFeatureIdentifier(this.edgeNum, e.end, name, f);
        }
        f.ystart = e.start;
        f.yend = e.end;
        f.val = 1.0f;
        ++this.edgeNum;
    }

    public boolean fixedTransitionFeatures() {
        return this.model.numStartStates() == this.model.numStates() && this.model.numEndStates() == this.model.numEndStates();
    }
}

