/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import iitb.Utils.Utils;

public class FeatureTypesConcat
extends FeatureTypes {
    FeatureTypes single;
    int numBits = 0;
    FeatureImpl feature = new FeatureImpl();
    private static final long serialVersionUID = 612L;
    private int maxConcatLength;

    public FeatureTypesConcat(FeatureGenImpl fgen, FeatureTypes single, int maxMemory) {
        super(fgen);
        this.single = single;
        int maxId = single.maxFeatureId() + 1;
        this.numBits = Utils.log2Ceil(maxId);
        this.thisTypeId = single.thisTypeId;
        this.maxConcatLength = maxMemory;
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        int bitMap = 0;
        String name = "";
        this.feature.strId.id = 0;
        if (pos - prevPos > this.maxConcatLength) {
            return false;
        }
        for (int i = 0; i < pos - prevPos && i < this.maxConcatLength; ++i) {
            if (!this.single.startScanFeaturesAt(data, pos - i - 1, pos - i) || !this.single.hasNext()) continue;
            this.single.next(this.feature);
            int thisId = this.offsetLabelIndependentId(this.feature) + 1;
            bitMap |= thisId << i * this.numBits;
            if (!this.featureCollectMode()) continue;
            name = this.feature.strId.name + "." + name;
            if (thisId > 1 << this.numBits) {
                System.out.println("Error in max-feature-id value " + this.feature);
            }
            if (!this.single.hasNext()) continue;
        }
        this.setFeatureIdentifier(bitMap, this.feature.strId.stateId, name, this.feature);
        return bitMap != 0;
    }

    public boolean hasNext() {
        return this.feature.strId.id > 0;
    }

    public void next(FeatureImpl f) {
        f.copy(this.feature);
        this.feature.strId.id = -1;
    }

    public boolean requiresTraining() {
        return this.single.requiresTraining();
    }

    public void train(DataSequence data, int pos) {
        this.single.train(data, pos);
    }
}

