/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import gnu.trove.TIntArrayList;
import iitb.CRF.DataSequence;
import iitb.CRF.SegmentCRF;
import iitb.CRF.SegmentDataSequence;
import iitb.Model.CompleteModel;
import iitb.Model.Edge;
import iitb.Model.EdgeIterator;
import iitb.Model.NestedModel;
import iitb.Model.NoEdgeModel;
import java.io.Serializable;

public abstract class Model
implements Serializable,
SegmentCRF.ModelGraph {
    int numLabels;
    public String name;

    Model(int nlabels) {
        this.numLabels = nlabels;
    }

    public int numberOfLabels() {
        return this.numLabels;
    }

    public abstract int numStates();

    public abstract int label(int var1);

    public abstract int numEdges();

    public abstract EdgeIterator edgeIterator();

    public EdgeIterator innerEdgeIterator() {
        return null;
    }

    public abstract int numStartStates();

    public abstract int numEndStates();

    public abstract boolean isEndState(int var1);

    public abstract boolean isStartState(int var1);

    public abstract int startState(int var1);

    public abstract int endState(int var1);

    public abstract void stateMappings(DataSequence var1) throws Exception;

    public void stateMappings(SegmentDataSequence data) throws Exception {
        this.stateMappings((DataSequence)data);
    }

    public abstract void stateMappings(DataSequence var1, int var2, int var3) throws Exception;

    public int stateMappingGivenLength(int label, int len, int posFromStart) throws Exception {
        return label;
    }

    public void printGraph() {
        int i;
        System.out.println("Numnodes = " + this.numStates() + " NumEdges " + this.numEdges());
        EdgeIterator iter = this.edgeIterator();
        iter.start();
        while (iter.hasNext()) {
            Edge edge = iter.next();
            System.out.println(edge.start + "-->" + edge.end);
        }
        System.out.print("Start states");
        for (i = 0; i < this.numStartStates(); ++i) {
            System.out.print(" " + this.startState(i));
        }
        System.out.println("");
        System.out.print("End states");
        for (i = 0; i < this.numEndStates(); ++i) {
            System.out.print(" " + this.endState(i));
        }
        System.out.println("");
    }

    public static Model getNewBaseModel(int numLabels, String modelSpecs) throws Exception {
        if (modelSpecs.equalsIgnoreCase("naive") || modelSpecs.equalsIgnoreCase("semi-markov")) {
            return new CompleteModel(numLabels);
        }
        if (modelSpecs.equalsIgnoreCase("noEdge")) {
            return new NoEdgeModel(numLabels);
        }
        throw new Exception("Base model can be one of {naive, noEdge, semi-Markov}");
    }

    public static Model getNewModel(int numLabels, String modelSpecs) throws Exception {
        try {
            return Model.getNewBaseModel(numLabels, modelSpecs);
        }
        catch (Exception e) {
            return new NestedModel(numLabels, modelSpecs);
        }
    }

    public void mapStatesToLabels(SegmentDataSequence dataSeq) {
        int dataLen = dataSeq.length();
        if (dataLen == 0) {
            return;
        }
        int segStart = 0;
        int segEnd = 0;
        while (segStart < dataLen) {
            for (segEnd = segStart; segEnd < dataLen; ++segEnd) {
                if (this.label(dataSeq.y(segStart)) != this.label(dataSeq.y(segEnd))) {
                    --segEnd;
                    System.out.println("WARNING: label ending in a state not marked as a End-state");
                    break;
                }
                if (this.isEndState(dataSeq.y(segEnd))) break;
            }
            if (segEnd == dataLen) {
                System.out.println("WARNING: End state not found until the last position");
                System.out.println(dataSeq);
                segEnd = dataLen - 1;
            }
            dataSeq.setSegment(segStart, segEnd, this.label(dataSeq.y(segStart)));
            segStart = segEnd + 1;
        }
    }

    public void stateMappingGivenLength(int label, int len, TIntArrayList stateIds) throws Exception {
    }
}

