/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import java.io.Serializable;

public class WindowFeatures
extends FeatureTypes {
    private static final long serialVersionUID = 6123L;
    protected FeatureTypes single;
    protected int currentWindow;
    int prevPos;
    protected int pos;
    protected transient DataSequence dataSeq;
    protected Window[] windows;
    private int dataLen;

    public WindowFeatures(Window[] windows, FeatureTypes single) {
        super(single);
        this.single = single;
        this.windows = windows;
    }

    protected boolean advance(boolean firstCall) {
        while (firstCall || !this.single.hasNext()) {
            --this.currentWindow;
            if (this.currentWindow < 0) {
                return false;
            }
            if (this.windows[this.currentWindow].maxLength < this.pos - this.prevPos || this.windows[this.currentWindow].minLength > this.pos - this.prevPos) continue;
            int rightB = this.windows[this.currentWindow].rightBoundary(this.prevPos + 1, this.pos);
            int leftB = this.windows[this.currentWindow].leftBoundary(this.prevPos + 1, this.pos);
            if (leftB >= this.dataLen || rightB < 0 || leftB > rightB) continue;
            this.single.startScanFeaturesAt(this.dataSeq, Math.max(leftB, 0) - 1, Math.min(rightB, this.dataLen - 1));
            firstCall = false;
        }
        return true;
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        this.currentWindow = this.windows.length;
        this.dataSeq = data;
        this.dataLen = this.dataSeq.length();
        this.prevPos = prevPos;
        this.pos = pos;
        return this.advance(true);
    }

    public boolean hasNext() {
        return this.single.hasNext() && this.currentWindow >= 0;
    }

    public void next(FeatureImpl f) {
        this.single.next(f);
        String name = "";
        if (this.featureCollectMode()) {
            name = name + f.strId.name + ".W." + this.windows[this.currentWindow];
        }
        this.setFeatureIdentifier(f.strId.id * this.windows.length + this.currentWindow, f.strId.stateId, name, f);
        this.advance(false);
    }

    public boolean requiresTraining() {
        return this.single.requiresTraining();
    }

    public void train(DataSequence data, int pos) {
        this.single.train(data, pos);
    }

    public static class Window
    implements Serializable {
        public int start;
        public boolean startRelativeToLeft;
        public int end;
        public boolean endRelativeToLeft;
        String winName = null;
        public int maxLength = Integer.MAX_VALUE;
        public int minLength = 1;

        public Window(int start, boolean startRelativeToLeft, int end, boolean endRelativeToLeft) {
            this(start, startRelativeToLeft, end, endRelativeToLeft, null);
            String startB = startRelativeToLeft ? "L" : "R";
            String endB = endRelativeToLeft ? "L" : "R";
            this.winName = startB + start + endB + end;
        }

        public Window(int start, boolean startRelativeToLeft, int end, boolean endRelativeToLeft, String winName) {
            this.start = start;
            this.startRelativeToLeft = startRelativeToLeft;
            this.end = end;
            this.endRelativeToLeft = endRelativeToLeft;
            this.winName = winName;
        }

        public Window(int start, boolean startRelativeToLeft, int end, boolean endRelativeToLeft, String winName, int minWinLength, int maxWinLength) {
            this(start, startRelativeToLeft, end, endRelativeToLeft, winName);
            this.maxLength = maxWinLength;
            this.minLength = minWinLength;
        }

        int leftBoundary(int segStart, int segEnd) {
            if (this.startRelativeToLeft) {
                return this.boundary(segStart, this.start);
            }
            return this.boundary(segEnd, this.start);
        }

        int rightBoundary(int segStart, int segEnd) {
            if (this.endRelativeToLeft) {
                return this.boundary(segStart, this.end);
            }
            return this.boundary(segEnd, this.end);
        }

        private int boundary(int boundary, int offset) {
            return boundary + offset;
        }

        public String toString() {
            return this.winName;
        }
    }
}

