/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import iitb.Model.WordFeatures;
import iitb.Model.WordsInTrain;

public class WordScoreFeatures
extends FeatureTypes {
    int stateId;
    int wordPos;
    WordsInTrain dict;

    public WordScoreFeatures(FeatureGenImpl m, WordsInTrain d) {
        super(m);
        this.dict = d;
    }

    private void nextStateId() {
        this.stateId = this.dict.nextStateWithWord(this.wordPos, this.stateId);
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        this.stateId = -1;
        if (this.dict.count(data.x(pos)) > WordFeatures.RARE_THRESHOLD) {
            Object token = data.x(pos);
            this.wordPos = this.dict.getIndex(token);
            this.stateId = -1;
            this.nextStateId();
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        return this.stateId < this.model.numStates() && this.stateId >= 0;
    }

    public void next(FeatureImpl f) {
        this.setFeatureIdentifier(this.stateId, this.stateId, "S", f);
        f.yend = this.stateId;
        f.ystart = -1;
        f.val = (float)Math.log((double)this.dict.count(this.wordPos, this.stateId) / (double)this.dict.count(this.stateId));
        this.nextStateId();
    }
}

