/*
 * Decompiled with CFR 0.152.
 */
package jal.DOUBLE;

import jal.DOUBLE.BinaryOperator;
import jal.DOUBLE.BinaryPredicate;
import jal.DOUBLE.Generator;
import jal.DOUBLE.Inspection;
import jal.DOUBLE.Predicate;
import jal.DOUBLE.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(dArray, n, dArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        while (n < n2) {
            double d = dArray2[n3];
            dArray2[n3] = dArray[n];
            dArray[n] = d;
            ++n;
            ++n3;
        }
    }

    public static void transform(double[] dArray, double[] dArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            dArray2[n3++] = unaryOperator.apply(dArray[n++]);
        }
    }

    public static void transform(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            dArray3[n4++] = binaryOperator.apply(dArray[n++], dArray2[n3++]);
        }
    }

    public static void replace(double[] dArray, int n, int n2, double d, double d2) {
        while (n < n2) {
            if (dArray[n] == d) {
                dArray[n] = d2;
            }
            ++n;
        }
    }

    public static void replace_if(double[] dArray, int n, int n2, Predicate predicate, double d) {
        while (n < n2) {
            if (predicate.apply(dArray[n])) {
                dArray[n] = d;
            }
            ++n;
        }
    }

    public static void replace_copy(double[] dArray, double[] dArray2, int n, int n2, int n3, double d, double d2) {
        while (n < n2) {
            double d3 = dArray[n++];
            double d4 = dArray2[n3++] = d3 == d ? d2 : d3;
        }
    }

    public static void replace_copy_if(double[] dArray, double[] dArray2, int n, int n2, int n3, Predicate predicate, double d) {
        while (n < n2) {
            double d2 = dArray[n++];
            double d3 = dArray2[n3++] = predicate.apply(d2) ? d : d2;
        }
    }

    public static void fill(double[] dArray, int n, int n2, double d) {
        while (n < n2) {
            dArray[n++] = d;
        }
    }

    public static void generate(double[] dArray, int n, int n2, Generator generator) {
        while (n < n2) {
            dArray[n++] = generator.apply();
        }
    }

    public static int remove_if(double[] dArray, int n, int n2, double d) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && dArray[n] != d) {
                continue;
            }
            while (n < --n2 && dArray[n2] == d) {
            }
            if (n >= n2) {
                return n;
            }
            dArray[n] = dArray[n2];
        }
    }

    public static int remove_if(double[] dArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(dArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(dArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            dArray[n] = dArray[n2];
        }
    }

    public static int stable_remove(double[] dArray, int n, int n2, double d) {
        n = Inspection.find(dArray, n, n2, d);
        int n3 = Inspection.find_not(dArray, n, n2, d);
        while (n3 < n2) {
            dArray[n++] = dArray[n3];
            ++n3;
            n3 = Inspection.find_not(dArray, n3, n2, d);
        }
        return n;
    }

    public static int stable_remove_if(double[] dArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(dArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(dArray, n, n2, predicate);
        while (n3 < n2) {
            dArray[n++] = dArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(dArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(double[] dArray, double[] dArray2, int n, int n2, int n3, double d) {
        while (n < n2) {
            double d2;
            if ((d2 = dArray[n++]) == d) continue;
            dArray2[n3++] = d2;
        }
        return n3;
    }

    public static int remove_copy_if(double[] dArray, double[] dArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            double d;
            if (predicate.apply(d = dArray[n++])) continue;
            dArray2[n3++] = d;
        }
        return n3;
    }

    public static int unique(double[] dArray, int n, int n2) {
        n = Inspection.adjacent_find(dArray, n, n2);
        return Modification.unique_copy(dArray, dArray, n, n2, n);
    }

    public static int unique(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(dArray, n, n2, binaryPredicate);
        return Modification.unique_copy(dArray, dArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        dArray2[n3] = dArray[n];
        while (++n < n2) {
            if (dArray2[n3] == dArray[n]) continue;
            dArray2[++n3] = dArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(double[] dArray, double[] dArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        dArray2[n3] = dArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(dArray2[n3], dArray[n])) continue;
            dArray2[++n3] = dArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(double[] dArray, int n, int n2) {
        while (n < --n2) {
            double d = dArray[n];
            dArray[n++] = dArray[n2];
            dArray[n2] = d;
        }
    }

    public static void reverse_copy(double[] dArray, int n, int n2, int n3) {
        while (n2 > n) {
            dArray[n3++] = dArray[--n2];
        }
    }

    public static void reverse_copy(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        while (n2 > n) {
            dArray2[n3++] = dArray[--n2];
        }
    }

    public static void rotate(double[] dArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(dArray, n, n2);
            Modification.reverse(dArray, n2, n3);
            Modification.reverse(dArray, n, n3);
        }
    }

    public static void rotate_copy(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
        Modification.copy(dArray, dArray2, n2, n3, n4);
        Modification.copy(dArray, dArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(double[] dArray, int n, int n2, Random random2) {
        int n3 = n + 1;
        while (n3 < n2) {
            int n4 = Math.abs(random2.nextInt()) % (n3 - n + 1);
            double d = dArray[n4];
            dArray[n4] = dArray[n3];
            dArray[n3] = d;
            ++n3;
        }
    }

    public static void random_shuffle(double[] dArray, int n, int n2) {
        Modification.random_shuffle(dArray, n, n2, default_RNG);
    }

    public static int partition(double[] dArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(dArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(dArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            double d = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = d;
        }
    }

    public static int stable_partition(double[] dArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(dArray, n, n3, predicate);
            int n5 = Modification.stable_partition(dArray, n3, n2, predicate);
            Modification.rotate(dArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(dArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

