/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.chart.event.LegendChangeListener;

public abstract class Legend
implements Serializable,
Cloneable {
    public static final int WEST = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    protected static final int INVERTED = 2;
    protected static final int HORIZONTAL = 1;
    private int anchor = 3;
    protected JFreeChart chart;
    private transient EventListenerList listenerList;
    static /* synthetic */ Class class$org$jfree$chart$event$LegendChangeListener;

    public static Legend createInstance(JFreeChart jFreeChart) {
        return new StandardLegend(jFreeChart);
    }

    public Legend() {
        this(null);
    }

    protected Legend(JFreeChart jFreeChart) {
        this.chart = jFreeChart;
        this.listenerList = new EventListenerList();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public abstract Rectangle2D draw(Graphics2D var1, Rectangle2D var2, ChartRenderingInfo var3);

    public void addChangeListener(LegendChangeListener legendChangeListener) {
        this.listenerList.add(class$org$jfree$chart$event$LegendChangeListener == null ? (class$org$jfree$chart$event$LegendChangeListener = Legend.class$("org.jfree.chart.event.LegendChangeListener")) : class$org$jfree$chart$event$LegendChangeListener, legendChangeListener);
    }

    public void removeChangeListener(LegendChangeListener legendChangeListener) {
        this.listenerList.remove(class$org$jfree$chart$event$LegendChangeListener == null ? (class$org$jfree$chart$event$LegendChangeListener = Legend.class$("org.jfree.chart.event.LegendChangeListener")) : class$org$jfree$chart$event$LegendChangeListener, legendChangeListener);
    }

    protected void notifyListeners(LegendChangeEvent legendChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jfree$chart$event$LegendChangeListener == null ? Legend.class$("org.jfree.chart.event.LegendChangeListener") : class$org$jfree$chart$event$LegendChangeListener)) continue;
            ((LegendChangeListener)objectArray[i + 1]).legendChanged(legendChangeEvent);
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.anchor = n;
                this.notifyListeners(new LegendChangeEvent(this));
                break;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Legend) {
            Legend legend = (Legend)object;
            return this.anchor == legend.anchor;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }

    protected Object clone() throws CloneNotSupportedException {
        Legend legend = (Legend)super.clone();
        this.listenerList = new EventListenerList();
        return legend;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

