/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.Marker;
import org.jfree.chart.Spacer;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotNotCompatibleException;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class CategoryPlot
extends Plot
implements ValueAxisPlot,
Cloneable,
PublicCloneable,
Serializable {
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private Spacer axisOffset;
    private CategoryAxis domainAxis;
    private AxisLocation domainAxisLocation;
    private ObjectList secondaryDomainAxes;
    private ObjectList secondaryDomainAxisLocations;
    private boolean drawSharedDomainAxis;
    private ValueAxis rangeAxis;
    private AxisLocation rangeAxisLocation;
    private ObjectList secondaryRangeAxes;
    private ObjectList secondaryRangeAxisLocations;
    private CategoryDataset dataset;
    private ObjectList secondaryDatasets;
    private ObjectList secondaryDatasetDomainAxisMap;
    private ObjectList secondaryDatasetRangeAxisMap;
    private CategoryItemRenderer renderer;
    private ObjectList secondaryRenderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.STANDARD;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private double anchorValue;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private transient List foregroundRangeMarkers;
    private transient List backgroundRangeMarkers;
    private transient Map secondaryForegroundRangeMarkers;
    private transient Map secondaryBackgroundRangeMarkers;
    private transient List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private transient List axesAtTop;
    private transient List axesAtBottom;
    private transient List axesAtLeft;
    private transient List axesAtRight;

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.secondaryDomainAxes = new ObjectList();
        this.secondaryDomainAxisLocations = new ObjectList();
        this.secondaryRangeAxes = new ObjectList();
        this.secondaryRangeAxisLocations = new ObjectList();
        this.secondaryDatasets = new ObjectList();
        this.secondaryDatasetDomainAxisMap = new ObjectList();
        this.secondaryDatasetRangeAxisMap = new ObjectList();
        this.secondaryRenderers = new ObjectList();
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        this.axisOffset = new Spacer(1, 0.0, 0.0, 0.0, 0.0);
        this.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT, false);
        this.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        this.renderer = categoryItemRenderer;
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
        }
        this.domainAxis = categoryAxis;
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.foregroundRangeMarkers = new ArrayList();
        this.backgroundRangeMarkers = new ArrayList();
        this.secondaryForegroundRangeMarkers = new HashMap();
        this.secondaryBackgroundRangeMarkers = new HashMap();
        Marker marker = new Marker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), 0.6f);
        this.addRangeMarker(marker, Layer.BACKGROUND);
        this.axesAtTop = new ArrayList();
        this.axesAtBottom = new ArrayList();
        this.axesAtLeft = new ArrayList();
        this.axesAtRight = new ArrayList();
        this.anchorValue = 0.0;
    }

    public String getPlotType() {
        return localizationResources.getString("Category_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation != this.orientation) {
            this.orientation = plotOrientation;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Spacer getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(Spacer spacer) {
        this.axisOffset = spacer;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryAxis getDomainAxis() {
        Plot plot;
        CategoryAxis categoryAxis = this.domainAxis;
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getDomainAxis();
        }
        return categoryAxis;
    }

    public void setDomainAxis(CategoryAxis categoryAxis) {
        if (categoryAxis != null) {
            try {
                categoryAxis.setPlot(this);
            }
            catch (PlotNotCompatibleException plotNotCompatibleException) {
                // empty catch block
            }
            categoryAxis.addChangeListener(this);
        }
        if (this.domainAxis != null) {
            this.domainAxis.removeChangeListener(this);
        }
        this.domainAxis = categoryAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getDomainAxisLocation() {
        return this.domainAxisLocation;
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl) {
        if (axisLocation != this.domainAxisLocation) {
            this.domainAxisLocation = axisLocation;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.domainAxisLocation, this.orientation);
    }

    public CategoryAxis getSecondaryDomainAxis(int n) {
        Plot plot;
        CategoryAxis categoryAxis = null;
        if (n < this.secondaryDomainAxes.size()) {
            categoryAxis = (CategoryAxis)this.secondaryDomainAxes.get(n);
        }
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getSecondaryDomainAxis(n);
        }
        return categoryAxis;
    }

    public void setSecondaryDomainAxis(int n, CategoryAxis categoryAxis) {
        CategoryAxis categoryAxis2 = this.getSecondaryDomainAxis(n);
        if (categoryAxis2 != null) {
            categoryAxis2.removeChangeListener(this);
        }
        if (categoryAxis != null) {
            try {
                categoryAxis.setPlot(this);
            }
            catch (PlotNotCompatibleException plotNotCompatibleException) {
                // empty catch block
            }
        }
        this.secondaryDomainAxes.set(n, categoryAxis);
        if (categoryAxis != null) {
            categoryAxis.configure();
            categoryAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryDomainAxes() {
        for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            CategoryAxis categoryAxis = (CategoryAxis)this.secondaryDomainAxes.get(i);
            if (categoryAxis == null) continue;
            categoryAxis.removeChangeListener(this);
        }
        this.secondaryDomainAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryDomainAxes() {
        for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            CategoryAxis categoryAxis = (CategoryAxis)this.secondaryDomainAxes.get(i);
            if (categoryAxis == null) continue;
            categoryAxis.configure();
        }
    }

    public AxisLocation getSecondaryDomainAxisLocation(int n) {
        Plot plot;
        AxisLocation axisLocation = null;
        if (n < this.secondaryDomainAxisLocations.size()) {
            axisLocation = (AxisLocation)this.secondaryDomainAxisLocations.get(n);
        }
        if (axisLocation == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            axisLocation = categoryPlot.getSecondaryDomainAxisLocation(n);
        }
        return axisLocation;
    }

    public void setSecondaryDomainAxisLocation(int n, AxisLocation axisLocation) {
        this.secondaryDomainAxisLocations.set(n, axisLocation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryDomainAxisEdge(int n) {
        AxisLocation axisLocation = this.getSecondaryDomainAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getDomainAxisEdge());
        }
        return rectangleEdge;
    }

    public ValueAxis getRangeAxis() {
        Plot plot;
        ValueAxis valueAxis = this.rangeAxis;
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getRangeAxis();
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        if (valueAxis != null) {
            try {
                valueAxis.setPlot(this);
            }
            catch (PlotNotCompatibleException plotNotCompatibleException) {
                // empty catch block
            }
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.removeChangeListener(this);
        }
        this.rangeAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getRangeAxisLocation() {
        return this.rangeAxisLocation;
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl) {
        if (axisLocation != this.rangeAxisLocation) {
            this.rangeAxisLocation = axisLocation;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.rangeAxisLocation, this.orientation);
    }

    public ValueAxis getSecondaryRangeAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.secondaryRangeAxes.size()) {
            valueAxis = (ValueAxis)this.secondaryRangeAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getSecondaryRangeAxis(n);
        }
        return valueAxis;
    }

    public void setSecondaryRangeAxis(int n, ValueAxis valueAxis) {
        ValueAxis valueAxis2 = this.getSecondaryRangeAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            try {
                valueAxis.setPlot(this);
            }
            catch (PlotNotCompatibleException plotNotCompatibleException) {
                // empty catch block
            }
        }
        this.secondaryRangeAxes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeAxes() {
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.secondaryRangeAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryRangeAxes() {
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public AxisLocation getSecondaryRangeAxisLocation(int n) {
        Plot plot;
        AxisLocation axisLocation = null;
        if (n < this.secondaryRangeAxisLocations.size()) {
            axisLocation = (AxisLocation)this.secondaryRangeAxisLocations.get(n);
        }
        if (axisLocation == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            axisLocation = categoryPlot.getSecondaryRangeAxisLocation(n);
        }
        return axisLocation;
    }

    public void setSecondaryRangeAxisLocation(int n, AxisLocation axisLocation) {
        this.secondaryRangeAxisLocations.set(n, axisLocation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryRangeAxisEdge(int n) {
        AxisLocation axisLocation = this.getSecondaryRangeAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getRangeAxisEdge());
        }
        return rectangleEdge;
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        CategoryDataset categoryDataset2 = this.dataset;
        if (categoryDataset2 != null) {
            categoryDataset2.removeChangeListener(this);
        }
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            this.setDatasetGroup(categoryDataset.getGroup());
            categoryDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, categoryDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public CategoryDataset getSecondaryDataset(int n) {
        CategoryDataset categoryDataset = null;
        if (this.secondaryDatasets.size() > n) {
            categoryDataset = (CategoryDataset)this.secondaryDatasets.get(n);
        }
        return categoryDataset;
    }

    public void setSecondaryDataset(int n, CategoryDataset categoryDataset) {
        CategoryDataset categoryDataset2 = (CategoryDataset)this.secondaryDatasets.get(n);
        if (categoryDataset2 != null) {
            categoryDataset2.removeChangeListener(this);
        }
        this.secondaryDatasets.set(n, categoryDataset);
        categoryDataset.addChangeListener(this);
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, categoryDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public void mapSecondaryDatasetToDomainAxis(int n, Integer n2) {
        this.secondaryDatasetDomainAxisMap.set(n, n2);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public void mapSecondaryDatasetToRangeAxis(int n, Integer n2) {
        this.secondaryDatasetRangeAxisMap.set(n, n2);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public ValueAxis getRangeAxisForSecondaryDataset(int n) {
        ValueAxis valueAxis = this.getRangeAxis();
        Integer n2 = (Integer)this.secondaryDatasetRangeAxisMap.get(n);
        if (n2 != null) {
            valueAxis = this.getSecondaryRangeAxis(n2);
        }
        return valueAxis;
    }

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(categoryItemRenderer, true);
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer, boolean bl) {
        this.renderer = categoryItemRenderer;
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryItemRenderer getSecondaryRenderer(int n) {
        CategoryItemRenderer categoryItemRenderer = null;
        if (this.secondaryRenderers.size() > n) {
            categoryItemRenderer = (CategoryItemRenderer)this.secondaryRenderers.get(n);
        }
        return categoryItemRenderer;
    }

    public void setSecondaryRenderer(int n, CategoryItemRenderer categoryItemRenderer) {
        CategoryItemRenderer categoryItemRenderer2 = this.getSecondaryRenderer(n);
        if (categoryItemRenderer2 != null) {
            // empty if block
        }
        this.secondaryRenderers.set(n, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        this.renderingOrder = datasetRenderingOrder;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor categoryAnchor) {
        this.domainGridlinePosition = categoryAnchor;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getLegendItems() {
        Object object;
        Object object2;
        int n;
        int n2;
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        CategoryDataset categoryDataset = this.getDataset();
        if (categoryDataset != null) {
            n2 = categoryDataset.getRowCount();
            for (n = 0; n < n2; ++n) {
                object2 = this.getRenderer();
                if (object2 == null) continue;
                object = object2.getLegendItem(0, n);
                legendItemCollection.add((LegendItem)object);
            }
        }
        n2 = this.secondaryDatasets.size();
        for (n = 0; n < n2; ++n) {
            object2 = this.getSecondaryDataset(n);
            if (object2 == null || (object = this.getSecondaryRenderer(n)) == null) continue;
            int n3 = object2.getRowCount();
            for (int i = 0; i < n3; ++i) {
                LegendItem legendItem = object.getLegendItem(n + 1, i);
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            float f = 0.0f;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                f = n;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                f = n2;
            }
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double d = this.rangeAxis.translateJava2DtoValue(f, plotRenderingInfo.getDataArea(), rectangleEdge);
            this.setAnchorValue(d);
            this.setRangeCrosshairValue(d);
        }
    }

    public void zoom(double d) {
        if (d > 0.0) {
            double d2 = this.rangeAxis.getRange().getLength();
            double d3 = d2 * d;
            this.rangeAxis.setRange(this.anchorValue - d3 / 2.0, this.anchorValue + d3 / 2.0);
        } else {
            this.rangeAxis.setAutoRange(true);
        }
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        int n = this.secondaryRangeAxes.size();
        for (int i = 0; i < n; ++i) {
            ValueAxis valueAxis = this.getSecondaryRangeAxis(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            if (this.foregroundRangeMarkers == null) {
                this.foregroundRangeMarkers = new ArrayList();
            }
            this.foregroundRangeMarkers.add(marker);
            this.notifyListeners(new PlotChangeEvent(this));
        } else if (layer == Layer.BACKGROUND) {
            if (this.backgroundRangeMarkers == null) {
                this.backgroundRangeMarkers = new ArrayList();
            }
            this.backgroundRangeMarkers.add(marker);
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void clearRangeMarkers() {
        if (this.foregroundRangeMarkers != null) {
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            this.backgroundRangeMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getRangeMarkers() {
        return this.getRangeMarkers(Layer.FOREGROUND);
    }

    public List getRangeMarkers(Layer layer) {
        if (layer == Layer.FOREGROUND) {
            return Collections.unmodifiableList(this.foregroundRangeMarkers);
        }
        if (layer == Layer.BACKGROUND) {
            return Collections.unmodifiableList(this.backgroundRangeMarkers);
        }
        throw new IllegalStateException("CategoryPlot.getRangeMarkers(..): layer?");
    }

    public void addSecondaryRangeMarker(Marker marker) {
        this.addSecondaryRangeMarker(0, marker, Layer.FOREGROUND);
    }

    public void addSecondaryRangeMarker(int n, Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.secondaryForegroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.secondaryForegroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.secondaryForegroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.secondaryBackgroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeMarkers() {
        this.clearSecondaryRangeMarkers(0);
    }

    public void clearSecondaryRangeMarkers(int n) {
        Integer n2 = new Integer(n);
        Collection collection = (Collection)this.secondaryBackgroundRangeMarkers.get(n2);
        if (collection != null) {
            collection.clear();
        }
        if ((collection = (Collection)this.secondaryForegroundRangeMarkers.get(n2)) != null) {
            collection.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getSecondaryRangeMarkers() {
        ArrayList arrayList = null;
        Collection collection = this.getSecondaryRangeMarkers(0, Layer.FOREGROUND);
        if (collection != null) {
            arrayList = new ArrayList(arrayList);
        }
        return arrayList;
    }

    public Collection getSecondaryRangeMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.secondaryForegroundRangeMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.secondaryBackgroundRangeMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(categoryAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block7: {
            block5: {
                block6: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block5;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block6;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block7;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block7;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block7;
            }
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.domainAxis != null) {
                axisSpace = this.domainAxis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            } else if (this.drawSharedDomainAxis) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
            for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                CategoryAxis categoryAxis = this.getSecondaryDomainAxis(i);
                if (categoryAxis == null) continue;
                RectangleEdge rectangleEdge2 = this.getSecondaryDomainAxisEdge(i);
                axisSpace = ((Axis)categoryAxis).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge2, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block5: {
            block3: {
                block4: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            ValueAxis valueAxis = this.rangeAxis;
            if (valueAxis != null) {
                axisSpace = valueAxis.reserveSpace(graphics2D, this, rectangle2D, this.getRangeAxisEdge(), axisSpace);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis2 = this.getSecondaryRangeAxis(i);
                if (valueAxis2 == null) continue;
                RectangleEdge rectangleEdge = this.getSecondaryRangeAxisEdge(i);
                axisSpace = valueAxis2.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D, axisSpace);
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        if (this.renderer != null) {
            this.renderer.drawBackground(graphics2D, this, rectangle2D2);
        } else {
            this.drawBackground(graphics2D, rectangle2D2);
        }
        this.drawAxes(graphics2D, rectangle2D, rectangle2D2);
        this.drawGridlines(graphics2D, rectangle2D2);
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            this.drawSecondaryRangeMarkers(graphics2D, rectangle2D2, i, Layer.BACKGROUND);
        }
        this.drawRangeMarkers(graphics2D, rectangle2D2, Layer.BACKGROUND);
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        if (datasetRenderingOrder == DatasetRenderingOrder.STANDARD) {
            this.render2(graphics2D, rectangle2D2, plotRenderingInfo);
            this.render(graphics2D, rectangle2D2, plotRenderingInfo);
        } else if (datasetRenderingOrder == DatasetRenderingOrder.REVERSE) {
            this.render(graphics2D, rectangle2D2, plotRenderingInfo);
            this.render2(graphics2D, rectangle2D2, plotRenderingInfo);
        }
        if (this.isRangeCrosshairVisible()) {
            this.drawRangeLine(graphics2D, rectangle2D2, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
        }
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            this.drawSecondaryRangeMarkers(graphics2D, rectangle2D2, i, Layer.FOREGROUND);
        }
        this.drawRangeMarkers(graphics2D, rectangle2D2, Layer.FOREGROUND);
        this.drawAnnotations(graphics2D, rectangle2D2);
        if (this.renderer != null) {
            this.renderer.drawOutline(graphics2D, this, rectangle2D2);
        } else {
            this.drawOutline(graphics2D, rectangle2D2);
        }
    }

    protected void drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d;
        Axis axis;
        Axis axis2;
        int n;
        this.axesAtTop.clear();
        this.axesAtBottom.clear();
        this.axesAtLeft.clear();
        this.axesAtRight.clear();
        if (this.domainAxis != null) {
            this.addAxisToList(this.domainAxis, this.getDomainAxisEdge());
        }
        if (this.rangeAxis != null) {
            this.addAxisToList(this.rangeAxis, this.getRangeAxisEdge());
        }
        for (n = 0; n < this.secondaryDomainAxes.size(); ++n) {
            axis2 = (CategoryAxis)this.secondaryDomainAxes.get(n);
            if (axis2 == null) continue;
            this.addAxisToList(axis2, this.getSecondaryDomainAxisEdge(n));
        }
        for (n = 0; n < this.secondaryRangeAxes.size(); ++n) {
            axis2 = (ValueAxis)this.secondaryRangeAxes.get(n);
            if (axis2 == null) continue;
            this.addAxisToList(axis2, this.getSecondaryRangeAxisEdge(n));
        }
        double d2 = rectangle2D2.getMinY() - this.axisOffset.getTopSpace(rectangle2D2.getHeight());
        Iterator iterator = this.axesAtTop.iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            d = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.TOP);
            d2 -= d;
        }
        d2 = rectangle2D2.getMaxY() + this.axisOffset.getBottomSpace(rectangle2D2.getHeight());
        iterator = this.axesAtBottom.iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            d = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM);
            d2 += d;
        }
        d2 = rectangle2D2.getMinX() - this.axisOffset.getLeftSpace(rectangle2D2.getWidth());
        iterator = this.axesAtLeft.iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            d = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.LEFT);
            d2 -= d;
        }
        d2 = rectangle2D2.getMaxX() + this.axisOffset.getRightSpace(rectangle2D2.getWidth());
        iterator = this.axesAtRight.iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            d = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.RIGHT);
            d2 += d;
        }
        this.axesAtTop.clear();
        this.axesAtBottom.clear();
        this.axesAtLeft.clear();
        this.axesAtRight.clear();
    }

    private void addAxisToList(Axis axis, RectangleEdge rectangleEdge) {
        if (rectangleEdge == RectangleEdge.TOP) {
            this.axesAtTop.add(axis);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            this.axesAtBottom.add(axis);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            this.axesAtLeft.add(axis);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            this.axesAtRight.add(axis);
        }
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        if (this.renderer == null) {
            return;
        }
        CategoryDataset categoryDataset = this.getDataset();
        if (!DatasetUtilities.isEmptyOrNull(categoryDataset)) {
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle2D);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            this.renderer.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
            int n = categoryDataset.getColumnCount();
            int n2 = categoryDataset.getRowCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.renderer.drawItem(graphics2D, rectangle2D, this, this.getDomainAxis(), this.getRangeAxis(), categoryDataset, j, i);
                }
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    public void render2(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        for (int i = 0; i < this.secondaryDatasets.size(); ++i) {
            CategoryItemRenderer categoryItemRenderer;
            CategoryDataset categoryDataset = this.getSecondaryDataset(i);
            if (DatasetUtilities.isEmptyOrNull(categoryDataset)) continue;
            ValueAxis valueAxis = this.getRangeAxisForSecondaryDataset(i);
            if (valueAxis == null) {
                valueAxis = this.getRangeAxis();
            }
            if ((categoryItemRenderer = this.getSecondaryRenderer(i)) == null) continue;
            categoryItemRenderer.initialise(graphics2D, rectangle2D, this, new Integer(i), plotRenderingInfo);
            int n = categoryDataset.getColumnCount();
            int n2 = categoryDataset.getRowCount();
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    categoryItemRenderer.drawItem(graphics2D, rectangle2D, this, this.getDomainAxis(), valueAxis, categoryDataset, k, j);
                }
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
    }

    protected void drawGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (this.isDomainGridlinesVisible()) {
            object6 = this.getDomainGridlinePosition();
            object5 = this.getDomainAxisEdge();
            object4 = this.getDomainGridlineStroke();
            object3 = this.getDomainGridlinePaint();
            if (object4 != null && object3 != null && (object2 = this.getDataset()) != null && (object = this.getDomainAxis()) != null) {
                int n = object2.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    double d = ((CategoryAxis)object).getCategoryJava2DCoordinate((CategoryAnchor)object6, i, n, rectangle2D, (RectangleEdge)object5);
                    CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                    if (categoryItemRenderer == null) continue;
                    categoryItemRenderer.drawDomainGridline(graphics2D, this, rectangle2D, d);
                }
            }
        }
        if (this.isRangeGridlinesVisible()) {
            object6 = this.getRangeGridlineStroke();
            object5 = this.getRangeGridlinePaint();
            if (object6 != null && object5 != null && (object4 = this.getRangeAxis()) != null) {
                object3 = this.getRangeAxis().getTicks().iterator();
                while (object3.hasNext()) {
                    object2 = (Tick)object3.next();
                    object = this.getRenderer();
                    if (object == null) continue;
                    object.drawRangeGridline(graphics2D, this, this.getRangeAxis(), rectangle2D, ((Tick)object2).getNumericalValue());
                }
            }
        }
    }

    protected void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.getAnnotations() != null) {
            Iterator iterator = this.getAnnotations().iterator();
            while (iterator.hasNext()) {
                CategoryAnnotation categoryAnnotation = (CategoryAnnotation)iterator.next();
                categoryAnnotation.draw(graphics2D, this, rectangle2D, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        List list = this.getRangeMarkers(layer);
        if (list != null && categoryItemRenderer != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                categoryItemRenderer.drawRangeMarker(graphics2D, this, this.getRangeAxis(), marker, rectangle2D);
            }
        }
    }

    protected void drawSecondaryRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        CategoryItemRenderer categoryItemRenderer = this.getSecondaryRenderer(0);
        if (categoryItemRenderer == null) {
            return;
        }
        if (this.getSecondaryRangeMarkers() != null) {
            Iterator iterator = this.getSecondaryRangeMarkers().iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawRangeMarker(graphics2D, this, this.getSecondaryRangeAxis(0), marker, rectangle2D);
            }
        }
    }

    protected void drawSecondaryRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getSecondaryRenderer(n);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getSecondaryRangeMarkers(n, layer);
        ValueAxis valueAxis = this.getSecondaryRangeAxis(n);
        if (collection != null && valueAxis != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D, this.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        ArrayList<CategoryDataset> arrayList = new ArrayList<CategoryDataset>();
        if (valueAxis == this.getRangeAxis()) {
            arrayList.add(this.dataset);
            arrayList.addAll(this.getSecondaryDatasetsMappedToRangeAxis(null));
        } else {
            int n = this.secondaryRangeAxes.indexOf(valueAxis);
            if (n >= 0) {
                arrayList.addAll(this.getSecondaryDatasetsMappedToRangeAxis(new Integer(n)));
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CategoryDataset categoryDataset = (CategoryDataset)iterator.next();
            RangeType rangeType = RangeType.STANDARD;
            if (this.renderer != null) {
                rangeType = this.renderer.getRangeType();
            }
            if (rangeType == RangeType.STACKED) {
                range = Range.combine(range, DatasetUtilities.getStackedRangeExtent(categoryDataset));
                continue;
            }
            range = Range.combine(range, DatasetUtilities.getRangeExtent(categoryDataset));
        }
        return range;
    }

    private List getSecondaryDatasetsMappedToRangeAxis(Integer n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.secondaryDatasetRangeAxisMap.size(); ++i) {
            Integer n2 = (Integer)this.secondaryDatasetRangeAxisMap.get(i);
            if (n2 == null) {
                if (n != null) continue;
                arrayList.add(this.secondaryDatasets.get(i));
                continue;
            }
            if (!n2.equals(n)) continue;
            arrayList.add(this.secondaryDatasets.get(i));
        }
        return arrayList;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.fixedDomainAxisSpace = axisSpace;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.fixedRangeAxisSpace = axisSpace;
    }

    public List getCategories() {
        List list = null;
        if (this.dataset != null) {
            list = Collections.unmodifiableList(this.dataset.getColumnKeys());
        }
        return list;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void zoomHorizontalAxes(double d) {
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.resizeRange(d);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (valueAxis == null) continue;
                valueAxis.resizeRange(d);
            }
        }
    }

    public void zoomHorizontalAxes(double d, double d2) {
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.zoomRange(d, d2);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (valueAxis == null) continue;
                valueAxis.zoomRange(d, d2);
            }
        }
    }

    public void zoomVerticalAxes(double d) {
        if (this.orientation == PlotOrientation.VERTICAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.resizeRange(d);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (valueAxis == null) continue;
                valueAxis.resizeRange(d);
            }
        }
    }

    public void zoomVerticalAxes(double d, double d2) {
        if (this.orientation == PlotOrientation.VERTICAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.zoomRange(d, d2);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (valueAxis == null) continue;
                valueAxis.zoomRange(d, d2);
            }
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double d) {
        this.setAnchorValue(d, true);
    }

    public void setAnchorValue(double d, boolean bl) {
        this.anchorValue = d;
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)object;
            boolean bl = this.orientation == categoryPlot.orientation;
            boolean bl2 = ObjectUtils.equal(this.axisOffset, categoryPlot.axisOffset);
            boolean bl3 = ObjectUtils.equal(this.domainAxis, categoryPlot.domainAxis);
            boolean bl4 = this.domainAxisLocation == categoryPlot.domainAxisLocation;
            boolean bl5 = this.secondaryDomainAxes.equals(categoryPlot.secondaryDomainAxes);
            boolean bl6 = this.secondaryDomainAxisLocations.equals(categoryPlot.secondaryDomainAxisLocations);
            boolean bl7 = ObjectUtils.equal(this.rangeAxis, categoryPlot.rangeAxis);
            boolean bl8 = this.rangeAxisLocation == categoryPlot.rangeAxisLocation;
            boolean bl9 = this.secondaryRangeAxes.equals(categoryPlot.secondaryRangeAxes);
            boolean bl10 = this.secondaryRangeAxisLocations.equals(categoryPlot.secondaryRangeAxisLocations);
            boolean bl11 = ObjectUtils.equal(this.secondaryDatasetDomainAxisMap, categoryPlot.secondaryDatasetDomainAxisMap);
            boolean bl12 = ObjectUtils.equal(this.secondaryDatasetRangeAxisMap, categoryPlot.secondaryDatasetRangeAxisMap);
            boolean bl13 = ObjectUtils.equal(this.renderer, categoryPlot.renderer);
            boolean bl14 = ObjectUtils.equal(this.secondaryRenderers, categoryPlot.secondaryRenderers);
            boolean bl15 = this.renderingOrder == categoryPlot.renderingOrder;
            boolean bl16 = this.domainGridlinesVisible == categoryPlot.domainGridlinesVisible;
            boolean bl17 = this.domainGridlinePosition == categoryPlot.domainGridlinePosition;
            boolean bl18 = ObjectUtils.equal(this.domainGridlineStroke, categoryPlot.domainGridlineStroke);
            boolean bl19 = ObjectUtils.equal(this.domainGridlinePaint, categoryPlot.domainGridlinePaint);
            boolean bl20 = this.anchorValue == categoryPlot.anchorValue;
            boolean bl21 = this.rangeGridlinesVisible == categoryPlot.rangeGridlinesVisible;
            boolean bl22 = ObjectUtils.equal(this.rangeGridlineStroke, categoryPlot.rangeGridlineStroke);
            boolean bl23 = ObjectUtils.equal(this.rangeGridlinePaint, categoryPlot.rangeGridlinePaint);
            boolean bl24 = this.rangeCrosshairVisible == categoryPlot.rangeCrosshairVisible;
            boolean bl25 = this.rangeCrosshairValue == categoryPlot.rangeCrosshairValue;
            boolean bl26 = ObjectUtils.equal(this.rangeCrosshairStroke, categoryPlot.rangeCrosshairStroke);
            boolean bl27 = ObjectUtils.equal(this.rangeCrosshairPaint, categoryPlot.rangeCrosshairPaint);
            boolean bl28 = this.rangeCrosshairLockedOnData == categoryPlot.rangeCrosshairLockedOnData;
            boolean bl29 = ObjectUtils.equal(this.foregroundRangeMarkers, categoryPlot.foregroundRangeMarkers);
            boolean bl30 = ObjectUtils.equal(this.backgroundRangeMarkers, categoryPlot.backgroundRangeMarkers);
            boolean bl31 = ObjectUtils.equal(this.secondaryForegroundRangeMarkers, categoryPlot.secondaryForegroundRangeMarkers);
            boolean bl32 = ObjectUtils.equal(this.secondaryBackgroundRangeMarkers, categoryPlot.secondaryBackgroundRangeMarkers);
            boolean bl33 = ObjectUtils.equal(this.annotations, categoryPlot.annotations);
            boolean bl34 = this.weight == categoryPlot.weight;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl23 && bl24 && bl25 && bl26 && bl27 && bl28 && bl29 && bl30 && bl31 && bl32 && bl33 && bl34;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        if (this.domainAxis != null) {
            categoryPlot.domainAxis = (CategoryAxis)this.domainAxis.clone();
            categoryPlot.domainAxis.setPlot(categoryPlot);
            categoryPlot.domainAxis.addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryDomainAxes = (ObjectList)this.secondaryDomainAxes.clone();
        for (n = 0; n < categoryPlot.secondaryDomainAxes.size(); ++n) {
            ((CategoryAxis)categoryPlot.secondaryDomainAxes.get(n)).setPlot(categoryPlot);
            ((CategoryAxis)categoryPlot.secondaryDomainAxes.get(n)).addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryDomainAxisLocations = (ObjectList)this.secondaryDomainAxisLocations.clone();
        if (this.rangeAxis != null) {
            categoryPlot.rangeAxis = (ValueAxis)this.rangeAxis.clone();
            categoryPlot.rangeAxis.setPlot(categoryPlot);
            categoryPlot.rangeAxis.addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryRangeAxes = (ObjectList)this.secondaryRangeAxes.clone();
        for (n = 0; n < categoryPlot.secondaryRangeAxes.size(); ++n) {
            ((CategoryAxis)categoryPlot.secondaryRangeAxes.get(n)).setPlot(categoryPlot);
            ((CategoryAxis)categoryPlot.secondaryRangeAxes.get(n)).addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryRangeAxisLocations = (ObjectList)this.secondaryRangeAxisLocations.clone();
        if (categoryPlot.dataset != null) {
            categoryPlot.dataset.addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryDatasets = (ObjectList)this.secondaryDatasets.clone();
        for (n = 0; n < categoryPlot.secondaryDatasets.size(); ++n) {
            ((CategoryDataset)categoryPlot.secondaryDatasets.get(n)).addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryDatasetDomainAxisMap = (ObjectList)this.secondaryDatasetDomainAxisMap.clone();
        categoryPlot.secondaryDatasetRangeAxisMap = (ObjectList)this.secondaryDatasetRangeAxisMap.clone();
        if (this.renderer != null) {
            if (this.renderer instanceof PublicCloneable) {
                PublicCloneable publicCloneable = (PublicCloneable)((Object)this.renderer);
                categoryPlot.renderer = (CategoryItemRenderer)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("CategoryPlot: renderer doesn't implement PublicCloneable.");
            }
        }
        categoryPlot.secondaryRenderers = (ObjectList)this.secondaryRenderers.clone();
        categoryPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtils.clone(this.fixedDomainAxisSpace);
        categoryPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtils.clone(this.fixedRangeAxisSpace);
        return categoryPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.domainGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeCrosshairPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        if (this.domainAxis != null) {
            this.domainAxis.setPlot(this);
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.setPlot(this);
            this.rangeAxis.addChangeListener(this);
        }
        this.foregroundRangeMarkers = new ArrayList();
        this.backgroundRangeMarkers = new ArrayList();
        this.secondaryForegroundRangeMarkers = new HashMap();
        this.secondaryBackgroundRangeMarkers = new HashMap();
        Marker marker = new Marker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), 0.6f);
        this.addRangeMarker(marker, Layer.BACKGROUND);
        this.axesAtTop = new ArrayList();
        this.axesAtBottom = new ArrayList();
        this.axesAtLeft = new ArrayList();
        this.axesAtRight = new ArrayList();
    }
}

