/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.Effect3D;
import org.jfree.chart.Marker;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class BarRenderer3D
extends BarRenderer
implements Effect3D,
Cloneable,
PublicCloneable,
Serializable {
    public static final double DEFAULT_X_OFFSET = 12.0;
    public static final double DEFAULT_Y_OFFSET = 8.0;
    public static final Paint DEFAULT_WALL_PAINT = new Color(221, 221, 221);
    private double xOffset;
    private double yOffset;
    private transient Paint wallPaint;
    private transient Area hiddenClip = null;

    public BarRenderer3D() {
        this(12.0, 8.0);
    }

    public BarRenderer3D(double d, double d2) {
        this.xOffset = d;
        this.yOffset = d2;
        this.wallPaint = DEFAULT_WALL_PAINT;
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        this.wallPaint = paint;
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = f + (float)Math.abs(this.xOffset);
        float f3 = (float)rectangle2D.getMaxX();
        float f4 = f3 - (float)Math.abs(this.xOffset);
        float f5 = (float)rectangle2D.getMaxY();
        float f6 = f5 - (float)Math.abs(this.yOffset);
        float f7 = (float)rectangle2D.getMinY();
        float f8 = f7 + (float)Math.abs(this.yOffset);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f5);
        generalPath.lineTo(f, f8);
        generalPath.lineTo(f2, f7);
        generalPath.lineTo(f3, f7);
        generalPath.lineTo(f3, f6);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        Paint paint = categoryPlot.getBackgroundPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath);
        }
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(f, f5);
        generalPath2.lineTo(f, f8);
        generalPath2.lineTo(f2, f7);
        generalPath2.lineTo(f2, f6);
        generalPath2.closePath();
        graphics2D.setPaint(this.getWallPaint());
        graphics2D.fill(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(f, f5);
        generalPath3.lineTo(f2, f6);
        generalPath3.lineTo(f3, f6);
        generalPath3.lineTo(f4, f5);
        generalPath3.closePath();
        graphics2D.setPaint(this.getWallPaint());
        graphics2D.fill(generalPath3);
        graphics2D.setPaint(Color.lightGray);
        Line2D.Double double_ = new Line2D.Double(f, f5, f2, f6);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(f2, f6, f2, f7);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(f2, f6, f3, f6);
        graphics2D.draw(double_);
        Image image = categoryPlot.getBackgroundImage();
        if (image != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(2, categoryPlot.getBackgroundAlpha()));
            graphics2D.drawImage(image, (int)f2, (int)f7, (int)(f3 - f2 + 1.0f), (int)(f6 - f7 + 1.0f), null);
            graphics2D.setComposite(composite);
        }
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = f + (float)Math.abs(this.xOffset);
        float f3 = (float)rectangle2D.getMaxX();
        float f4 = f3 - (float)Math.abs(this.xOffset);
        float f5 = (float)rectangle2D.getMaxY();
        float f6 = f5 - (float)Math.abs(this.yOffset);
        float f7 = (float)rectangle2D.getMinY();
        float f8 = f7 + (float)Math.abs(this.yOffset);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f5);
        generalPath.lineTo(f, f8);
        generalPath.lineTo(f2, f7);
        generalPath.lineTo(f3, f7);
        generalPath.lineTo(f3, f6);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        Stroke stroke = categoryPlot.getOutlineStroke();
        Paint paint = categoryPlot.getOutlinePaint();
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(generalPath);
        }
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        double d2;
        Line2D.Double double_ = null;
        Line2D.Double double_2 = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d2 = d;
            double d3 = d - this.getYOffset();
            double d4 = rectangle2D.getMinX();
            double d5 = d4 + this.getXOffset();
            double d6 = rectangle2D.getMaxY();
            double_ = new Line2D.Double(d4, d2, d5, d3);
            double_2 = new Line2D.Double(d5, d3, d6, d3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d2 = d;
            double d7 = d + this.getXOffset();
            double d8 = rectangle2D.getMaxY();
            double d9 = d8 - this.getYOffset();
            double d10 = rectangle2D.getMinY();
            double_ = new Line2D.Double(d2, d8, d7, d9);
            double_2 = new Line2D.Double(d7, d9, d7, d10);
        }
        Paint paint = categoryPlot.getDomainGridlinePaint();
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        double d2;
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        Line2D.Double double_2 = null;
        Line2D.Double double_3 = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d2 = valueAxis.translateValueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
            double d3 = d2 + this.getXOffset();
            double d4 = rectangle2D.getMaxY();
            double d5 = d4 - this.getYOffset();
            double d6 = rectangle2D.getMinY();
            double_2 = new Line2D.Double(d2, d4, d3, d5);
            double_3 = new Line2D.Double(d3, d5, d3, d6);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d2 = valueAxis.translateValueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
            double d7 = d2 - this.getYOffset();
            double d8 = rectangle2D.getMinX();
            double d9 = d8 + this.getXOffset();
            double d10 = rectangle2D.getMaxX();
            double_2 = new Line2D.Double(d8, d2, d9, d7);
            double_3 = new Line2D.Double(d9, d7, d10, d7);
        }
        Paint paint = categoryPlot.getRangeGridlinePaint();
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_2);
        graphics2D.draw(double_3);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        GeneralPath generalPath = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            float f = (float)valueAxis.translateValueToJava2D(marker.getValue(), double_, categoryPlot.getRangeAxisEdge());
            float f2 = (float)double_.getMaxY();
            generalPath = new GeneralPath();
            generalPath.moveTo(f, f2);
            generalPath.lineTo((float)((double)f + this.getXOffset()), f2 - (float)this.getYOffset());
            generalPath.lineTo((float)((double)f + this.getXOffset()), (float)(double_.getMinY() - this.getYOffset()));
            generalPath.lineTo(f, (float)double_.getMinY());
            generalPath.closePath();
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            float f = (float)valueAxis.translateValueToJava2D(marker.getValue(), double_, categoryPlot.getRangeAxisEdge());
            float f3 = (float)rectangle2D.getX();
            generalPath = new GeneralPath();
            generalPath.moveTo(f3, f);
            generalPath.lineTo(f3 + (float)this.xOffset, f - (float)this.yOffset);
            generalPath.lineTo((float)(double_.getMaxX() + this.xOffset), f - (float)this.yOffset);
            generalPath.lineTo((float)double_.getMaxX(), f);
            generalPath.closePath();
        }
        graphics2D.setPaint(marker.getPaint());
        graphics2D.fill(generalPath);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(generalPath);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    protected void drawHorizontalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Number number;
        if (n == 0 && n2 == 0) {
            this.hiddenClip = new Area(graphics2D.getClip());
        }
        if ((number = categoryDataset.getValue(n, n2)) != null) {
            EntityCollection entityCollection;
            CategoryItemLabelGenerator categoryItemLabelGenerator;
            double d;
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
            double d2 = number.doubleValue();
            double d3 = 0.0;
            double d4 = this.getLowerClip();
            double d5 = this.getUpperClip();
            if (d5 <= 0.0) {
                if (d2 >= d5) {
                    return;
                }
                d3 = d5;
                if (d2 <= d4) {
                    d2 = d4;
                }
            } else if (d4 <= 0.0) {
                if (d2 >= d5) {
                    d2 = d5;
                } else if (d2 <= d4) {
                    d2 = d4;
                }
            } else {
                if (d2 <= d4) {
                    return;
                }
                d3 = d4;
                if (d2 >= d5) {
                    d2 = d5;
                }
            }
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            double d6 = valueAxis.translateValueToJava2D(d3, double_, rectangleEdge);
            double d7 = valueAxis.translateValueToJava2D(d2, double_, rectangleEdge);
            double d8 = Math.min(d6, d7);
            double d9 = Math.max(d6, d7);
            double d10 = d8 + this.getXOffset();
            double d11 = d9 + this.getXOffset();
            double d12 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), double_, categoryPlot.getDomainAxisEdge());
            int n3 = this.getRowCount();
            int n4 = this.getColumnCount();
            if (n3 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n4 * (n3 - 1));
                d12 += (double)n * (this.getBarWidth() + d);
            } else {
                d12 += (double)n * this.getBarWidth();
            }
            d = d12 + this.getBarWidth();
            double d13 = d - this.getYOffset();
            double d14 = d12 - this.getYOffset();
            if ((double)categoryPlot.getForegroundAlpha() == 1.0) {
                graphics2D.setClip(this.hiddenClip);
            }
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d8, d12, d9 - d8, d - d12);
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.fill(double_2);
            this.hiddenClip.subtract(new Area(double_2));
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            if (d9 - d8 != 0.0) {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)d9, (float)d12);
                generalPath.lineTo((float)d9, (float)d);
                generalPath.lineTo((float)d11, (float)d13);
                generalPath.lineTo((float)d11, (float)d14);
                generalPath.closePath();
                graphics2D.fill(generalPath);
                this.hiddenClip.subtract(new Area(generalPath));
                generalPath2 = new GeneralPath();
                generalPath2.moveTo((float)d8, (float)d12);
                generalPath2.lineTo((float)d10, (float)d14);
                generalPath2.lineTo((float)d11, (float)d14);
                generalPath2.lineTo((float)d9, (float)d12);
                generalPath2.closePath();
                graphics2D.fill(generalPath2);
                this.hiddenClip.subtract(new Area(generalPath2));
            }
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_2);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
            }
            if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
                this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_2, d6 > d7);
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getOwner().getEntityCollection()) != null) {
                String string2 = null;
                categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
                if (categoryItemLabelGenerator != null) {
                    string2 = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string3 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string3 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_2, string2, string3, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }

    protected void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            CategoryItemLabelGenerator categoryItemLabelGenerator;
            double d;
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
            double d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), double_, categoryPlot.getDomainAxisEdge());
            int n3 = this.getRowCount();
            int n4 = this.getColumnCount();
            if (n3 > 1) {
                d = ((RectangularShape)double_).getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
                d2 += (double)n * (this.getBarWidth() + d);
            } else {
                d2 += (double)n * this.getBarWidth();
            }
            d = number.doubleValue();
            double d3 = 0.0;
            double d4 = this.getLowerClip();
            double d5 = this.getUpperClip();
            if (d5 <= 0.0) {
                if (d >= d5) {
                    return;
                }
                d3 = d5;
                if (d <= d4) {
                    d = d4;
                }
            } else if (d4 <= 0.0) {
                if (d >= d5) {
                    d = d5;
                } else if (d <= d4) {
                    d = d4;
                }
            } else {
                if (d <= d4) {
                    return;
                }
                d3 = d4;
                if (d >= d5) {
                    d = d5;
                }
            }
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            double d6 = valueAxis.translateValueToJava2D(d3, double_, rectangleEdge);
            double d7 = valueAxis.translateValueToJava2D(d, double_, rectangleEdge);
            double d8 = Math.min(d6, d7);
            double d9 = d2 + this.getBarWidth();
            double d10 = Math.max(d6, d7);
            double d11 = d2 + this.xOffset;
            double d12 = d9 + this.xOffset;
            double d13 = d10 - this.yOffset;
            double d14 = d8 - this.yOffset;
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d8, d9 - d2, d10 - d8);
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_2);
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            if (d10 - d8 != 0.0) {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)d9, (float)d8);
                generalPath.lineTo((float)d9, (float)d10);
                generalPath.lineTo((float)d12, (float)d13);
                generalPath.lineTo((float)d12, (float)d14);
                generalPath.closePath();
                if (paint instanceof Color) {
                    graphics2D.setPaint(((Color)paint).darker());
                }
                graphics2D.fill(generalPath);
            }
            generalPath2 = new GeneralPath();
            generalPath2.moveTo((float)d2, (float)d8);
            generalPath2.lineTo((float)d11, (float)d14);
            generalPath2.lineTo((float)d12, (float)d14);
            generalPath2.lineTo((float)d9, (float)d8);
            generalPath2.closePath();
            graphics2D.fill(generalPath2);
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_2);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
            }
            if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
                this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_2, d6 > d7);
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getOwner().getEntityCollection()) != null) {
                GeneralPath generalPath3 = new GeneralPath();
                generalPath3.moveTo((float)d2, (float)d10);
                generalPath3.lineTo((float)d2, (float)d8);
                generalPath3.lineTo((float)d11, (float)d14);
                generalPath3.lineTo((float)d12, (float)d14);
                generalPath3.lineTo((float)d12, (float)d13);
                generalPath3.lineTo((float)d9, (float)d10);
                generalPath3.closePath();
                String string2 = null;
                categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
                if (categoryItemLabelGenerator != null) {
                    string2 = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string3 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string3 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(generalPath3, string2, string3, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.wallPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.wallPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

