/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.PublicCloneable;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private double gapThreshold = 1.0;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private Boolean defaultShapesFilled;
    private transient Line2D line;

    public StandardXYItemRenderer() {
        this(2, new StandardXYToolTipGenerator());
    }

    public StandardXYItemRenderer(int n) {
        this(n, new StandardXYToolTipGenerator());
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        this(n, xYToolTipGenerator, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if ((n & 1) != 0) {
            this.plotShapes = true;
        }
        if ((n & 2) != 0) {
            this.plotLines = true;
        }
        if ((n & 4) != 0) {
            this.plotImages = true;
        }
        if ((n & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.defaultShapesFilled = Boolean.TRUE;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public void setPlotShapes(boolean bl) {
        if (this.plotShapes != bl) {
            Boolean bl2 = new Boolean(this.plotShapes);
            this.plotShapes = bl;
            this.firePropertyChanged("renderer.PlotShapes", bl2, new Boolean(bl));
        }
    }

    public boolean getItemShapeFilled(int n, int n2) {
        return this.getSeriesShapesFilled(n);
    }

    public boolean getSeriesShapesFilled(int n) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean bl = this.seriesShapesFilled.getBoolean(n);
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        if (bl) {
            this.setShapesFilled(Boolean.TRUE);
        } else {
            this.setShapesFilled(Boolean.FALSE);
        }
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
    }

    public Boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(Boolean bl) {
        this.defaultShapesFilled = bl;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean bl) {
        if (this.plotLines != bl) {
            Boolean bl2 = new Boolean(this.plotLines);
            this.plotLines = bl;
            this.firePropertyChanged("renderer.PlotLines", bl2, new Boolean(bl));
        }
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double d) {
        Double d2 = new Double(this.gapThreshold);
        this.gapThreshold = d;
        this.firePropertyChanged("renderer.GapThreshold", d2, new Double(d));
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean bl) {
        if (this.plotImages != bl) {
            Boolean bl2 = new Boolean(this.plotImages);
            this.plotImages = bl;
            this.firePropertyChanged("renderer.PlotImages", bl2, new Boolean(bl));
        }
    }

    public boolean getPlotDiscontinuous() {
        return this.plotDiscontinuous;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        Object object;
        Object object2;
        Object object3 = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        if (number2 == null || number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis.translateValueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.translateValueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (this.plotLines && n2 > 0) {
            object2 = xYDataset.getXValue(n, n2 - 1);
            object = xYDataset.getYValue(n, n2 - 1);
            if (object != null && object2 != null) {
                double d5 = ((Number)object2).doubleValue();
                double d6 = ((Number)object).doubleValue();
                boolean bl = true;
                if (this.plotDiscontinuous) {
                    int n4 = xYDataset.getItemCount(n);
                    double d7 = xYDataset.getXValue(n, 0).doubleValue();
                    double d8 = xYDataset.getXValue(n, n4 - 1).doubleValue();
                    boolean bl2 = bl = d - d5 <= (d8 - d7) / (double)n4 * this.gapThreshold;
                }
                if (bl) {
                    double d9 = valueAxis.translateValueToJava2D(d5, rectangle2D, rectangleEdge);
                    double d10 = valueAxis2.translateValueToJava2D(d6, rectangle2D, rectangleEdge2);
                    if (Double.isNaN(d9) || Double.isNaN(d10) || Double.isNaN(d3) || Double.isNaN(d4)) {
                        return;
                    }
                    PlotOrientation plotOrientation = xYPlot.getOrientation();
                    if (plotOrientation == PlotOrientation.HORIZONTAL) {
                        this.line.setLine(d10, d9, d4, d3);
                    } else if (plotOrientation == PlotOrientation.VERTICAL) {
                        this.line.setLine(d9, d10, d3, d4);
                    }
                    if (this.line.intersects(rectangle2D)) {
                        graphics2D.draw(this.line);
                    }
                }
            }
        }
        if (this.plotShapes) {
            object2 = this.getItemShape(n, n2);
            object = xYPlot.getOrientation();
            if (object == PlotOrientation.HORIZONTAL) {
                object2 = this.createTransformedShape((Shape)object2, d4, d3);
            } else if (object == PlotOrientation.VERTICAL) {
                object2 = this.createTransformedShape((Shape)object2, d3, d4);
            }
            if (object2.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n, n2)) {
                    graphics2D.fill((Shape)object2);
                } else {
                    graphics2D.draw((Shape)object2);
                }
            }
            object3 = object2;
        }
        if (this.plotImages && (object2 = this.getImage(xYPlot, n, n2, d3, d4)) != null) {
            object = this.getImageHotspot(xYPlot, n, n2, d3, d4, (Image)object2);
            graphics2D.drawImage((Image)object2, (int)(d3 - ((Point)object).getX()), (int)(d4 - ((Point)object).getY()), null);
            object3 = new Rectangle2D.Double(d3 - ((Point)object).getX(), d4 - ((Point)object).getY(), ((Image)object2).getWidth(null), ((Image)object2).getHeight(null));
        }
        if (entityCollection != null) {
            if (object3 == null) {
                object3 = new Rectangle2D.Double(d3 - 2.0, d4 - 2.0, 4.0, 4.0);
            }
            object2 = null;
            if (this.getToolTipGenerator() != null) {
                object2 = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            object = null;
            if (this.getURLGenerator() != null) {
                object = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity((Shape)object3, xYDataset, n, n2, (String)object2, (String)object);
            entityCollection.addEntity(xYItemEntity);
        }
        if (xYPlot.isDomainCrosshairLockedOnData()) {
            if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(d, d2, d3, d4);
            } else {
                crosshairInfo.updateCrosshairX(d);
            }
        } else if (xYPlot.isRangeCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(d2);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)object;
            if (super.equals(object)) {
                boolean bl = this.plotShapes == standardXYItemRenderer.plotShapes;
                boolean bl2 = this.plotLines == standardXYItemRenderer.plotLines;
                boolean bl3 = this.plotImages == standardXYItemRenderer.plotImages;
                boolean bl4 = this.plotDiscontinuous == standardXYItemRenderer.plotDiscontinuous;
                boolean bl5 = this.gapThreshold == standardXYItemRenderer.gapThreshold;
                return bl && bl2 && bl3 && bl4 && bl5;
            }
        }
        return false;
    }

    protected Image getImage(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int n, int n2, double d, double d2, Image image) {
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        return new Point(n4 / 2, n3 / 2);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }
}

