/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import org.jfree.data.AbstractDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.XYDataset;

public class JDBCXYDataset
extends AbstractDataset
implements XYDataset,
RangeInfo {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    ResultSetMetaData metaData;
    String[] columnNames = new String[0];
    Vector rows = new Vector(0);
    protected double maxValue = 0.0;
    protected double minValue = 0.0;
    public boolean isTimeSeries = false;

    public JDBCXYDataset() {
    }

    public JDBCXYDataset(String string2, String string3, String string4, String string5) {
        try {
            Class.forName(string3);
            this.connection = DriverManager.getConnection(string2, string4, string5);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(classNotFoundException);
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to this database.");
            System.err.println(sQLException);
        }
    }

    public JDBCXYDataset(Connection connection) {
        try {
            this.connection = connection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JDBCXYDataset(Connection connection, String string2) {
        this(connection);
        this.executeQuery(string2);
    }

    public void executeQuery(String string2) {
        this.executeQuery(this.connection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void executeQuery(Connection connection, String string2) {
        block46: {
            Exception exception2222;
            block44: {
                Object object = null;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int[] nArray = null;
                if (connection == null) {
                    System.err.println("There is no database to execute the query.");
                    return;
                }
                this.statement = connection.createStatement();
                this.resultSet = this.statement.executeQuery(string2);
                this.metaData = this.resultSet.getMetaData();
                n3 = this.metaData.getColumnCount();
                nArray = new int[n3];
                for (n = 0; n < n3; ++n) {
                    try {
                        int n5 = this.metaData.getColumnType(n + 1);
                        switch (n5) {
                            case -7: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 91: 
                            case 92: 
                            case 93: {
                                ++n4;
                                nArray[n] = n5;
                                break;
                            }
                            default: {
                                System.err.println("Unable to load column " + n + " (" + n5 + "," + this.metaData.getColumnClassName(n + 1) + ")");
                                nArray[n] = 0;
                                break;
                            }
                        }
                        continue;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        nArray[n] = 0;
                    }
                }
                this.columnNames = new String[n4 - 1];
                n2 = 0;
                for (n = 1; n < n3; ++n) {
                    if (nArray[n] == 0) continue;
                    this.columnNames[n2] = this.metaData.getColumnLabel(n + 1);
                    ++n2;
                }
                if (this.rows != null) {
                    for (n = 0; n < this.rows.size(); ++n) {
                        Vector vector = (Vector)this.rows.get(n);
                        vector.removeAllElements();
                    }
                    this.rows.removeAllElements();
                }
                switch (nArray[0]) {
                    case 91: 
                    case 92: 
                    case 93: {
                        this.isTimeSeries = true;
                        break;
                    }
                    default: {
                        this.isTimeSeries = false;
                    }
                }
                this.rows = new Vector();
                while (this.resultSet.next()) {
                    Vector<Object> vector = new Vector<Object>();
                    block29: for (n = 0; n < n3; ++n) {
                        object = this.resultSet.getObject(n + 1);
                        switch (nArray[n]) {
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 8: {
                                vector.addElement(object);
                                continue block29;
                            }
                            case 91: 
                            case 92: 
                            case 93: {
                                vector.addElement(new Long(((Date)object).getTime()));
                                continue block29;
                            }
                            case 0: {
                                continue block29;
                            }
                            default: {
                                System.err.println("Unknown data");
                                nArray[n] = 0;
                            }
                        }
                    }
                    this.rows.addElement(vector);
                }
                if (this.rows.size() == 0) {
                    Vector<Integer> vector = new Vector<Integer>();
                    for (n = 0; n < n3; ++n) {
                        if (nArray[n] == 0) continue;
                        vector.addElement(new Integer(0));
                    }
                    this.rows.addElement(vector);
                }
                if (this.rows.size() < 1) {
                    this.maxValue = 0.0;
                    this.minValue = 0.0;
                } else {
                    Vector vector = (Vector)this.rows.elementAt(0);
                    this.minValue = this.maxValue = ((Number)vector.get(1)).doubleValue();
                    for (int i = 0; i < this.rows.size(); ++i) {
                        vector = (Vector)this.rows.elementAt(i);
                        for (n = 1; n < n3; ++n) {
                            double d = ((Number)vector.get(n)).doubleValue();
                            if (d < this.minValue) {
                                this.minValue = d;
                            }
                            if (!(d > this.maxValue)) continue;
                            this.maxValue = d;
                        }
                    }
                }
                this.fireDatasetChanged();
                Object var14_18 = null;
                if (this.resultSet == null) break block44;
                try {
                    this.resultSet.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception exception2222) {}
            }
            break block46;
            {
                catch (SQLException sQLException) {
                    Exception exception32222;
                    System.err.println(sQLException);
                    sQLException.printStackTrace();
                    Object var14_19 = null;
                    if (this.resultSet != null) {
                        try {
                            this.resultSet.close();
                        }
                        catch (Exception exception32222) {
                            // empty catch block
                        }
                    }
                    if (this.statement != null) {
                        try {
                            this.statement.close();
                        }
                        catch (Exception exception32222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var14_20 = null;
                if (this.resultSet != null) {
                    try {
                        this.resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public Number getXValue(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n2);
        return (Number)vector.elementAt(0);
    }

    public Number getYValue(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n2);
        return (Number)vector.elementAt(n + 1);
    }

    public int getItemCount(int n) {
        return this.rows.size();
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public String getSeriesName(int n) {
        if (n < this.columnNames.length && this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public Number getMinimumRangeValue() {
        return new Double(this.minValue);
    }

    public Number getMaximumRangeValue() {
        return new Double(this.maxValue);
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
        try {
            this.statement.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    public Range getValueRange() {
        return new Range(this.minValue, this.maxValue);
    }
}

