/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.Series;
import org.jfree.data.SeriesException;
import org.jfree.data.XYDataItem;
import org.jfree.data.XYDataPair;
import org.jfree.util.ObjectUtils;

public class XYSeries
extends Series
implements Serializable {
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean allowDuplicateXValues;

    public XYSeries(String string2) {
        this(string2, true);
    }

    public XYSeries(String string2, boolean bl) {
        super(string2);
        this.allowDuplicateXValues = bl;
        this.data = new ArrayList();
    }

    public int getItemCount() {
        return this.data.size();
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
    }

    public void add(XYDataItem xYDataItem) throws SeriesException {
        this.add(xYDataItem, true);
    }

    public void add(XYDataItem xYDataItem, boolean bl) throws SeriesException {
        if (xYDataItem == null) {
            throw new IllegalArgumentException("XYSeries.add(...): null item not allowed.");
        }
        boolean bl2 = false;
        int n = Collections.binarySearch(this.data, xYDataItem);
        if (n < 0) {
            this.data.add(-n - 1, xYDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
            bl2 = true;
        } else if (this.allowDuplicateXValues) {
            this.data.add(n, xYDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
            bl2 = true;
        } else {
            throw new SeriesException("XYSeries.add(...): x-value already exists.");
        }
        if (bl && bl2) {
            this.fireSeriesChanged();
        }
    }

    public void add(double d, double d2) throws SeriesException {
        this.add(new Double(d), (Number)new Double(d2), true);
    }

    public void add(double d, double d2, boolean bl) throws SeriesException {
        this.add(new Double(d), (Number)new Double(d2), bl);
    }

    public void add(double d, Number number) throws SeriesException {
        this.add(new Double(d), number);
    }

    public void add(double d, Number number, boolean bl) throws SeriesException {
        this.add(new Double(d), number, bl);
    }

    public void add(Number number, Number number2) throws SeriesException {
        this.add(number, number2, true);
    }

    public void add(Number number, Number number2, boolean bl) throws SeriesException {
        XYDataItem xYDataItem = new XYDataItem(number, number2);
        this.add(xYDataItem, bl);
    }

    public void delete(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.data.remove(n);
        }
        this.fireSeriesChanged();
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public XYDataPair getDataPair(int n) {
        return (XYDataPair)this.data.get(n);
    }

    public XYDataItem getDataItem(int n) {
        return (XYDataItem)this.data.get(n);
    }

    public Number getXValue(int n) {
        return this.getDataItem(n).getX();
    }

    public Number getYValue(int n) {
        return this.getDataItem(n).getY();
    }

    public void update(int n, Number number) {
        XYDataItem xYDataItem = this.getDataItem(n);
        xYDataItem.setY(number);
        this.fireSeriesChanged();
    }

    public Object clone() {
        XYSeries xYSeries = this.createCopy(0, this.getItemCount() - 1);
        return xYSeries;
    }

    public XYSeries createCopy(int n, int n2) {
        XYSeries xYSeries = (XYSeries)super.clone();
        xYSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i = n; i <= n2; ++i) {
                XYDataItem xYDataItem = (XYDataItem)this.data.get(i);
                XYDataItem xYDataItem2 = (XYDataItem)xYDataItem.clone();
                try {
                    xYSeries.add(xYDataItem2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    System.err.println("XYSeries.createCopy(): unable to add cloned data pair.");
                }
            }
        }
        return xYSeries;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof XYSeries) {
            XYSeries xYSeries = (XYSeries)object;
            boolean bl = ObjectUtils.equal(this.data, xYSeries.data);
            boolean bl2 = this.maximumItemCount == xYSeries.maximumItemCount;
            boolean bl3 = this.allowDuplicateXValues == xYSeries.allowDuplicateXValues;
            return bl && bl2 && bl3;
        }
        return false;
    }
}

