/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class IOUtils {
    private static IOUtils instance;

    protected IOUtils() {
    }

    public static IOUtils getInstance() {
        if (instance == null) {
            instance = new IOUtils();
        }
        return instance;
    }

    private boolean isFileStyleProtocol(URL uRL) {
        if (uRL.getProtocol().equals("http")) {
            return true;
        }
        if (uRL.getProtocol().equals("https")) {
            return true;
        }
        if (uRL.getProtocol().equals("ftp")) {
            return true;
        }
        if (uRL.getProtocol().equals("file")) {
            return true;
        }
        if (uRL.getProtocol().equals("jar")) {
            return true;
        }
        return uRL.getProtocol().equals("http");
    }

    private List parseName(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (string3.length() == 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String formatName(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    private int startsWithUntil(List list, List list2) {
        int n = Math.min(list2.size(), list.size());
        int n2 = 0;
        while (n2 < n) {
            String string2;
            String string3 = (String)list.get(n2);
            if (!string3.equals(string2 = (String)list2.get(n2))) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    private boolean isSameService(URL uRL, URL uRL2) {
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return false;
        }
        if (!uRL.getHost().equals(uRL2.getHost())) {
            return false;
        }
        return uRL.getPort() == uRL2.getPort();
    }

    public String createRelativeURL(URL uRL, URL uRL2) {
        if (this.isFileStyleProtocol(uRL) && this.isSameService(uRL, uRL2)) {
            List list;
            ArrayList<String> arrayList = new ArrayList<String>();
            List list2 = this.parseName(uRL.getFile());
            int n = this.startsWithUntil(list2, list = this.parseName(uRL2.getFile()));
            if (n == 0) {
                return uRL.toExternalForm();
            }
            if (uRL.equals(uRL2)) {
                return "";
            }
            if (n == list2.size()) {
                --n;
            }
            if (list.size() >= list2.size()) {
                int n2 = list.size() - n;
                int n3 = 0;
                while (n3 < n2) {
                    arrayList.add("..");
                    ++n3;
                }
            }
            arrayList.addAll(list2.subList(n, list2.size()));
            return this.formatName(arrayList);
        }
        return uRL.toExternalForm();
    }

    public void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.copyStreams(inputStream, outputStream, 4096);
    }

    public void copyStreams(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        while (inputStream.available() != 0) {
            int n2 = inputStream.read(byArray);
            if (n2 <= -1) break;
            outputStream.write(byArray, 0, n2);
        }
    }

    public void copyWriter(Reader reader, Writer writer) throws IOException {
        this.copyWriter(reader, writer, 4096);
    }

    public void copyWriter(Reader reader, Writer writer, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = reader.read(cArray);
        while (n2 > -1) {
            writer.write(cArray, 0, n2);
            n2 = reader.read(cArray);
        }
    }

    public String getFileName(URL uRL) {
        String string2 = uRL.getFile();
        int n = string2.lastIndexOf("/");
        if (n < 0) {
            return string2;
        }
        return string2.substring(n);
    }

    public String stripFileExtension(String string2) {
        int n = string2.lastIndexOf(".");
        if (n < 1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public boolean isSubDirectory(File file, File file2) throws IOException {
        file = file.getCanonicalFile();
        File file3 = file2 = file2.getCanonicalFile();
        while (file3 != null) {
            if (file.equals(file3)) {
                return true;
            }
            file3 = file3.getParentFile();
        }
        return false;
    }
}

