/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jfree.ui.about.AboutPanel;
import org.jfree.ui.about.ContributorsPanel;
import org.jfree.ui.about.LibraryPanel;
import org.jfree.ui.about.ProjectInfo;
import org.jfree.ui.about.SystemPropertiesPanel;

public class AboutFrame
extends JFrame {
    public static final Dimension PREFERRED_SIZE = new Dimension(560, 360);
    public static final Border STANDARD_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private ResourceBundle resources;
    private String application;
    private String version;
    private String copyright;
    private String info;
    private Image logo;
    private List contributors;
    private String licence;
    private List libraries;

    public AboutFrame(String string2, ProjectInfo projectInfo) {
        this(string2, projectInfo.getName(), "Version " + projectInfo.getVersion(), projectInfo.getInfo(), projectInfo.getLogo(), projectInfo.getCopyright(), projectInfo.getLicenceText(), projectInfo.getContributors(), projectInfo.getLibraries());
    }

    public AboutFrame(String string2, String string3, String string4, String string5, Image image, String string6, String string7, List list, List list2) {
        super(string2);
        this.application = string3;
        this.version = string4;
        this.copyright = string6;
        this.info = string5;
        this.logo = image;
        this.contributors = list;
        this.licence = string7;
        this.libraries = list2;
        String string8 = "org.jfree.ui.about.resources.AboutResources";
        this.resources = ResourceBundle.getBundle(string8);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(STANDARD_BORDER);
        JTabbedPane jTabbedPane = this.createTabs();
        jPanel.add(jTabbedPane);
        this.setContentPane(jPanel);
        this.pack();
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    private JTabbedPane createTabs() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = this.createAboutPanel();
        jPanel.setBorder(STANDARD_BORDER);
        String string2 = this.resources.getString("about-frame.tab.about");
        jTabbedPane.add(string2, jPanel);
        SystemPropertiesPanel systemPropertiesPanel = new SystemPropertiesPanel();
        systemPropertiesPanel.setBorder(STANDARD_BORDER);
        String string3 = this.resources.getString("about-frame.tab.system");
        jTabbedPane.add(string3, systemPropertiesPanel);
        return jTabbedPane;
    }

    private JPanel createAboutPanel() {
        String string2;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        AboutPanel aboutPanel = new AboutPanel(this.application, this.version, this.copyright, this.info, this.logo);
        boolean bl = false;
        JTabbedPane jTabbedPane = new JTabbedPane();
        if (this.contributors != null) {
            jPanel = new ContributorsPanel(this.contributors);
            jPanel.setBorder(STANDARD_BORDER);
            string2 = this.resources.getString("about-frame.tab.contributors");
            jTabbedPane.add(string2, jPanel);
            bl = true;
        }
        if (this.licence != null) {
            jPanel = this.createLicencePanel();
            jPanel.setBorder(STANDARD_BORDER);
            string2 = this.resources.getString("about-frame.tab.licence");
            jTabbedPane.add(string2, jPanel);
            bl = true;
        }
        if (this.libraries != null) {
            jPanel = new LibraryPanel(this.libraries);
            jPanel.setBorder(STANDARD_BORDER);
            string2 = this.resources.getString("about-frame.tab.libraries");
            jTabbedPane.add(string2, jPanel);
            bl = true;
        }
        jPanel2.add((Component)aboutPanel, "North");
        if (bl) {
            jPanel2.add(jTabbedPane);
        }
        return jPanel2;
    }

    private JPanel createLicencePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea(this.licence);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        jPanel.add(new JScrollPane(jTextArea));
        return jPanel;
    }
}

