/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.util.Log;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.Parser;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ParserFrontend {
    private Parser defaulthandler;
    private SAXParserFactory factory;
    private EntityResolver entityResolver;
    private boolean validateDTD;

    protected ParserFrontend(Parser parser2) {
        if (parser2 == null) {
            throw new NullPointerException();
        }
        this.defaulthandler = parser2;
    }

    public boolean isValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean bl) {
        this.validateDTD = bl;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        block3: {
            if (this.factory != null) break block3;
            this.factory = SAXParserFactory.newInstance();
            if (this.isValidateDTD()) {
                try {
                    this.factory.setValidating(true);
                }
                catch (Exception exception) {
                    Log.debug("The parser will not validate the xml document.", exception);
                }
            }
        }
        return this.factory.newSAXParser();
    }

    public void setDefaultHandler(Parser parser2) {
        if (parser2 == null) {
            throw new NullPointerException();
        }
        this.defaulthandler = parser2;
    }

    public Parser getDefaultHandler() {
        return this.defaulthandler;
    }

    protected Parser createDefaultHandler(URL uRL) {
        Parser parser2 = this.getDefaultHandler().getInstance();
        if (uRL != null) {
            parser2.setConfigProperty("content-base", uRL.toExternalForm());
        }
        return parser2;
    }

    protected Object parse(InputSource inputSource, URL uRL) throws ElementDefinitionException {
        try {
            SAXParser sAXParser = this.getParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", this.isValidateDTD());
            }
            catch (SAXException sAXException) {
                Log.debug("The XMLReader will not validate the xml document.", sAXException);
            }
            Parser parser2 = this.createDefaultHandler(uRL);
            this.configureReader(xMLReader, parser2);
            try {
                xMLReader.setContentHandler(parser2);
                xMLReader.setDTDHandler(parser2);
                xMLReader.setEntityResolver(this.getEntityResolver());
                xMLReader.setErrorHandler(parser2);
                xMLReader.parse(inputSource);
                return parser2.getResult();
            }
            catch (IOException iOException) {
                throw new ElementDefinitionException(iOException);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ElementDefinitionException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ElementDefinitionException(sAXException);
        }
    }

    protected void configureReader(XMLReader xMLReader, Parser parser2) {
    }

    public Object parse(URL uRL, URL uRL2) throws ElementDefinitionException, IOException {
        if (uRL == null) {
            throw new NullPointerException("File may not be null");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        InputSource inputSource = new InputSource(bufferedInputStream);
        inputSource.setSystemId(uRL.toString());
        Object object = this.parse(inputSource, uRL2);
        bufferedInputStream.close();
        return object;
    }
}

