/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.ClassFactoryImpl;
import org.jfree.xml.factory.objects.ObjectDescription;

public class ClassFactoryCollector
extends ClassFactoryImpl {
    private ArrayList factories = new ArrayList();

    public void addFactory(ClassFactory classFactory) {
        this.factories.add(classFactory);
        if (this.getConfig() != null) {
            classFactory.configure(this.getConfig());
        }
    }

    public Iterator getFactories() {
        return this.factories.iterator();
    }

    public ObjectDescription getDescriptionForClass(Class clazz) {
        int n = 0;
        while (n < this.factories.size()) {
            ClassFactory classFactory = (ClassFactory)this.factories.get(n);
            ObjectDescription objectDescription = classFactory.getDescriptionForClass(clazz);
            if (objectDescription != null) {
                return objectDescription;
            }
            ++n;
        }
        return super.getDescriptionForClass(clazz);
    }

    public ObjectDescription getSuperClassObjectDescription(Class clazz, ObjectDescription objectDescription) {
        int n = 0;
        while (n < this.factories.size()) {
            ClassFactory classFactory = (ClassFactory)this.factories.get(n);
            ObjectDescription objectDescription2 = classFactory.getSuperClassObjectDescription(clazz, objectDescription);
            if (objectDescription2 != null) {
                if (objectDescription == null) {
                    objectDescription = objectDescription2;
                } else if (this.getComparator().isComparable(objectDescription.getObjectClass(), objectDescription2.getObjectClass()) && this.getComparator().compare(objectDescription.getObjectClass(), objectDescription2.getObjectClass()) < 0) {
                    objectDescription = objectDescription2;
                }
            }
            ++n;
        }
        return super.getSuperClassObjectDescription(clazz, objectDescription);
    }

    public Iterator getRegisteredClasses() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.factories.size()) {
            ClassFactory classFactory = (ClassFactory)this.factories.get(n);
            Iterator iterator = classFactory.getRegisteredClasses();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public void configure(Configuration configuration) {
        if (this.getConfig() != null) {
            return;
        }
        super.configure(configuration);
        Iterator iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            ClassFactory classFactory = (ClassFactory)iterator.next();
            classFactory.configure(configuration);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassFactoryCollector)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ClassFactoryCollector classFactoryCollector = (ClassFactoryCollector)object;
        return this.factories.equals(classFactoryCollector.factories);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + this.factories.hashCode();
        return n;
    }
}

