/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.sre;

import java.util.Vector;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.imp;
import org.python.modules.sre.MatchObject;
import org.python.modules.sre.SRE_STATE;
import org.python.modules.sre.ScannerObject;

public class PatternObject
extends PyObject {
    char[] code;
    public String pattern;
    public int groups;
    public PyObject groupindex;
    public int flags;
    PyObject indexgroup;

    public MatchObject match(String string2) {
        return this.match(string2, 0, Integer.MAX_VALUE);
    }

    public MatchObject match(String string2, int start) {
        return this.match(string2, start, Integer.MAX_VALUE);
    }

    public MatchObject match(String string2, int start, int end) {
        SRE_STATE state = new SRE_STATE(string2, start, end, this.flags);
        state.ptr = state.start;
        int status = state.SRE_MATCH(this.code, 0, 1);
        return this._pattern_new_match(state, string2, status);
    }

    public MatchObject search(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("search", args, kws, "pattern", "pos", "endpos");
        String string2 = ap.getString(0);
        int start = ap.getInt(1, 0);
        int end = ap.getInt(2, string2.length());
        SRE_STATE state = new SRE_STATE(string2, start, end, this.flags);
        int status = state.SRE_SEARCH(this.code, 0);
        return this._pattern_new_match(state, string2, status);
    }

    public PyObject sub(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("sub", args, kws, "repl", "string", "count");
        PyObject template = ap.getPyObject(0);
        String string2 = ap.getString(1);
        int count = ap.getInt(2, 0);
        return this.call("_sub", new PyObject[]{Py.java2py(this), template, Py.newString(string2), Py.newInteger(count)});
    }

    public PyObject subn(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("subn", args, kws, "repl", "string", "count");
        PyObject template = ap.getPyObject(0);
        String string2 = ap.getString(1);
        int count = ap.getInt(2, 0);
        return this.call("_subn", new PyObject[]{Py.java2py(this), template, Py.newString(string2), Py.newInteger(count)});
    }

    public PyObject split(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("split", args, kws, "source", "maxsplit");
        String string2 = ap.getString(0);
        int count = ap.getInt(1, 0);
        return this.call("_split", new PyObject[]{Py.java2py(this), Py.newString(string2), Py.newInteger(count)});
    }

    private final PyObject call(String function, PyObject[] args) {
        PyObject sre2 = imp.importName("sre", true);
        return sre2.invoke(function, args);
    }

    public PyObject findall(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("findall", args, kws, "source", "pos", "endpos");
        String string2 = ap.getString(0);
        int start = ap.getInt(1, 0);
        int end = ap.getInt(2, Integer.MAX_VALUE);
        SRE_STATE state = new SRE_STATE(string2, start, end, this.flags);
        Vector<PyString> list = new Vector<PyString>();
        while (state.start <= state.end) {
            state.state_reset();
            state.ptr = state.start;
            int status = state.SRE_SEARCH(this.code, 0);
            if (status > 0) {
                PySequence item;
                switch (this.groups) {
                    case 0: {
                        item = Py.newString(string2.substring(state.start, state.ptr));
                        break;
                    }
                    case 1: {
                        item = Py.newString(state.getslice(1, string2));
                        break;
                    }
                    default: {
                        PyObject[] t = new PyObject[this.groups];
                        int i = 0;
                        while (i < this.groups) {
                            t[i] = Py.newString(state.getslice(i + 1, string2));
                            ++i;
                        }
                        item = new PyTuple(t);
                        break;
                    }
                }
                list.addElement((PyString)item);
                if (state.ptr == state.start) {
                    state.start = state.ptr + 1;
                    continue;
                }
                state.start = state.ptr;
                continue;
            }
            if (status == 0) break;
            this._error(status);
        }
        return new PyList(list);
    }

    public ScannerObject scanner(String string2) {
        return this.scanner(string2, 0, Integer.MAX_VALUE);
    }

    public ScannerObject scanner(String string2, int start) {
        return this.scanner(string2, start, Integer.MAX_VALUE);
    }

    public ScannerObject scanner(String string2, int start, int end) {
        ScannerObject self = new ScannerObject();
        self.state = new SRE_STATE(string2, start, end, this.flags);
        self.pattern = this;
        self.string = string2;
        return self;
    }

    private final void _error(int status) {
        if (status == -3) {
            throw Py.RuntimeError("maximum recursion limit exceeded");
        }
        throw Py.RuntimeError("internal error in regular expression engine");
    }

    MatchObject _pattern_new_match(SRE_STATE state, String string2, int status) {
        if (status > 0) {
            MatchObject match = new MatchObject();
            match.pattern = this;
            match.string = string2;
            match.regs = null;
            match.groups = this.groups + 1;
            int base = state.beginning;
            match.mark = new int[match.groups * 2];
            match.mark[0] = state.start - base;
            match.mark[1] = state.ptr - base;
            int j = 0;
            int i = 0;
            while (i < this.groups) {
                if (j + 1 <= state.lastmark && state.mark[j] != -1 && state.mark[j + 1] != -1) {
                    match.mark[j + 2] = state.mark[j] - base;
                    match.mark[j + 3] = state.mark[j + 1] - base;
                } else {
                    match.mark[j + 3] = -1;
                    match.mark[j + 2] = -1;
                }
                ++i;
                j += 2;
            }
            match.pos = state.pos;
            match.endpos = state.endpos;
            match.lastindex = state.lastindex;
            return match;
        }
        if (status == 0) {
            return null;
        }
        this._error(status);
        return null;
    }

    public PatternObject(PyString pattern, int flags, char[] code, int groups, PyObject groupindex, PyObject indexgroup) {
        this.pattern = pattern.toString();
        this.flags = flags;
        this.code = code;
        this.groups = groups;
        this.groupindex = groupindex;
        this.indexgroup = indexgroup;
    }
}

