/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.inv;

import com.lgc.wsh.inv.LogMonitor;
import com.lgc.wsh.inv.Monitor;
import com.lgc.wsh.util.Almost;
import com.lgc.wsh.util.IndexSorter;
import java.util.logging.Logger;

public class ScalarSolver {
    private static final Logger LOG;
    private static final double GOLD;
    private Function _function = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ScalarSolver(Function function) {
        this._function = function;
    }

    public double solve(double scalarMin, double scalarMax, double okError, double okFraction, int numberIterations, Monitor monitor) {
        int i;
        if (monitor == null) {
            monitor = new LogMonitor(null, null);
        }
        monitor.report(0.0);
        int iter = 0;
        int nter = numberIterations;
        if (nter < 6) {
            nter = 6;
        }
        double[] xs = new double[]{0.0, 0.25, 0.75, 1.0};
        double[] fs = new double[4];
        boolean allZerosInd = true;
        for (i = 0; i < fs.length; ++i) {
            fs[i] = this.function(xs[i], scalarMin, scalarMax);
            if (fs[i] == 0.0) continue;
            allZerosInd = false;
        }
        iter = 4;
        while (allZerosInd) {
            ++iter;
            xs[1] = xs[1] + (0.5 - xs[1]) * 0.6;
            xs[2] = xs[2] + (xs[2] - 0.5) * 0.6;
            for (i = 1; i < fs.length - 1; ++i) {
                fs[i] = this.function(xs[i], scalarMin, scalarMax);
                if (fs[i] == 0.0) continue;
                allZerosInd = false;
            }
        }
        double xmin = 3.4028234663852886E38;
        double error = 1.0;
        double previousError = 1.0;
        double previousPreviousError = 1.0;
        double fraction = 1.0;
        while (true) {
            monitor.report((double)iter / (double)nter);
            int imin = this.sort(xs, fs);
            xmin = xs[imin];
            previousPreviousError = previousError;
            previousError = error;
            if (imin == 0) {
                error = xs[1] - xs[0];
            } else if (imin == 3) {
                error = xs[3] - xs[2];
            } else if (imin == 1 || imin == 2) {
                error = xs[imin + 1] - xs[imin - 1];
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("impossible imin=" + imin));
            }
            fraction = Almost.FLOAT.divide(error, xmin, 0.0);
            if (iter >= nter || error < okError && fraction < okFraction) break;
            double xnew = 3.4028234663852886E38;
            if (imin == 0) {
                if (!$assertionsDisabled && xs[imin] != 0.0) {
                    throw new AssertionError((Object)"Left endpoint should be zero");
                }
                xnew = xs[1] * 0.1;
            } else if (imin == 3) {
                if (!$assertionsDisabled && xs[imin] != 1.0) {
                    throw new AssertionError((Object)"Right endpoint should be one");
                }
                xnew = 1.0 - 0.1 * (1.0 - xs[2]);
            } else if (imin == 1 || imin == 2) {
                boolean goodConvergence = false;
                if (error < previousPreviousError * 0.501) {
                    try {
                        xnew = this.minParabola(xs[imin - 1], fs[imin - 1], xs[imin], fs[imin], xs[imin + 1], fs[imin + 1]);
                        goodConvergence = true;
                    }
                    catch (BadParabolaException e) {
                        goodConvergence = false;
                    }
                }
                if (!goodConvergence) {
                    xnew = xs[imin] - xs[imin - 1] >= xs[imin + 1] - xs[imin] ? xs[imin - 1] + GOLD * (xs[imin] - xs[imin - 1]) : xs[imin + 1] - GOLD * (xs[imin + 1] - xs[imin]);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Impossible imin=" + imin));
            }
            if (!$assertionsDisabled && xnew == 3.4028234663852886E38) {
                throw new AssertionError((Object)"bad xnew");
            }
            double fnew = 3.4028234663852886E38;
            for (int i2 = 0; i2 < xs.length; ++i2) {
                if (!Almost.FLOAT.equal(xnew, xs[i2])) continue;
                fnew = fs[i2];
            }
            if (fnew == 3.4028234663852886E38) {
                fnew = this.function(xnew, scalarMin, scalarMax);
            }
            if (imin < 2) {
                xs[3] = xnew;
                fs[3] = fnew;
            } else {
                xs[0] = xnew;
                fs[0] = fnew;
            }
            ++iter;
        }
        if (!($assertionsDisabled || xmin >= 0.0 && xmin <= 1.0)) {
            throw new AssertionError((Object)("Impossible xmin=" + xmin));
        }
        double result = scalarMin + xmin * (scalarMax - scalarMin);
        monitor.report(1.0);
        return result;
    }

    private int sort(double[] xs, double[] fs) {
        int[] sortedX = new IndexSorter(xs).getSortedIndices();
        double[] xsOld = (double[])xs.clone();
        double[] fsOld = (double[])fs.clone();
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = xsOld[sortedX[i]];
            fs[i] = fsOld[sortedX[i]];
        }
        int imin = 0;
        for (int i = 1; i < fs.length; ++i) {
            if (!(fs[i] < fs[imin])) continue;
            imin = i;
        }
        return imin;
    }

    private double function(double x, double scalarMin, double scalarMax) {
        return this.function(scalarMin + x * (scalarMax - scalarMin));
    }

    private double function(double scalar) {
        return this._function.function(scalar);
    }

    private double minParabola(double x1, double f1, double x2, double f2, double x3, double f3) throws BadParabolaException, IllegalArgumentException {
        double b;
        if (!Almost.FLOAT.le(x1, x2) || !Almost.FLOAT.le(x2, x3)) {
            throw new BadParabolaException("Violates x1 <= x2 <= x3: x1=" + x1 + " x2=" + x2 + " x3=" + x3);
        }
        if (Almost.FLOAT.equal(x1, x2)) {
            double result = x2 + 0.1 * (x3 - x2);
            return result;
        }
        if (Almost.FLOAT.equal(x2, x3)) {
            double result = x1 + 0.9 * (x2 - x1);
            return result;
        }
        if (!Almost.FLOAT.le(f2, f1) || !Almost.FLOAT.le(f2, f3)) {
            throw new BadParabolaException("Violates f(x2) <= f(x1), f(x2) <= f(x3): f1=" + f1 + " f2=" + f2 + " f3=" + f3);
        }
        double xm = Almost.FLOAT.divide(x2 - x1, x3 - x1, 0.0);
        if (xm < 0.001 || xm > 0.999) {
            throw new BadParabolaException("Parabola is badly sampled x1=" + x1 + " x2=" + x2 + " x3=" + x3);
        }
        double a = Almost.FLOAT.divide((f3 - f1) * xm - (f2 - f1), xm - xm * xm, 0.0);
        if (Almost.FLOAT.ge(a * (b = f3 - f1 - a), 0.0) || 0.5 * Math.abs(b) > Math.abs(a)) {
            throw new BadParabolaException("Poor numerical conditioning a=" + a + " b=" + b);
        }
        xm = Almost.FLOAT.divide(-0.5 * b, a, -1.0);
        if (xm < 0.0 || xm > 1.0) {
            throw new BadParabolaException("Poor numerical conditioning a=" + a + " b=" + b + " xm=" + xm);
        }
        double result = xm * (x3 - x1) + x1;
        return result;
    }

    public static void main(String[] args) throws Exception {
        double answer = 0.3333333333333333;
        final int[] calls = new int[]{0};
        ScalarSolver solver = new ScalarSolver(new Function(){

            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.abs(scalar - 0.3333333333333333);
            }
        });
        double xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 20, null);
        if (!$assertionsDisabled && !(xmin > 0.3323333333333333)) {
            throw new AssertionError((Object)"xmin > answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin > 0.33299999999999996)) {
            throw new AssertionError((Object)"xmin > answer*(1. - 0.001)");
        }
        if (!$assertionsDisabled && !(xmin < 0.3343333333333333)) {
            throw new AssertionError((Object)"xmin < answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin < 0.3336666666666666)) {
            throw new AssertionError((Object)"xmin < answer*(1. + 0.001)");
        }
        if (!$assertionsDisabled && calls[0] != 14) {
            throw new AssertionError((Object)("calls[0] == 14 != " + calls[0]));
        }
        answer = 0.3333333333333333;
        calls = new int[]{0};
        solver = new ScalarSolver(new Function(){

            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.abs(scalar - 0.3333333333333333);
            }
        });
        xmin = solver.solve(-1.0, 2.0, 0.001, 0.001, 20, null);
        if (!$assertionsDisabled && !(xmin > 0.3323333333333333)) {
            throw new AssertionError((Object)"xmin > answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin > 0.33299999999999996)) {
            throw new AssertionError((Object)"xmin > answer*(1. - 0.001)");
        }
        if (!$assertionsDisabled && !(xmin < 0.3343333333333333)) {
            throw new AssertionError((Object)"xmin < answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin < 0.3336666666666666)) {
            throw new AssertionError((Object)"xmin < answer*(1. + 0.001)");
        }
        if (!$assertionsDisabled && calls[0] != 15) {
            throw new AssertionError((Object)("calls[0] == 15 != " + calls[0]));
        }
        answer = 0.03;
        calls = new int[]{0};
        solver = new ScalarSolver(new Function(){

            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.abs(scalar - 0.03);
            }
        });
        xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 20, null);
        if (!$assertionsDisabled && !(xmin > 0.028999999999999998)) {
            throw new AssertionError((Object)"xmin > answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin > 0.02997)) {
            throw new AssertionError((Object)"xmin > answer*(1. - 0.001)");
        }
        if (!$assertionsDisabled && !(xmin < 0.031)) {
            throw new AssertionError((Object)"xmin < answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin < 0.030029999999999994)) {
            throw new AssertionError((Object)"xmin < answer*(1. + 0.001)");
        }
        if (!$assertionsDisabled && calls[0] != 16) {
            throw new AssertionError((Object)("calls[0] == 16 != " + calls[0]));
        }
        answer = 0.98;
        calls = new int[]{0};
        solver = new ScalarSolver(new Function(){

            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.abs(scalar - 0.98);
            }
        });
        xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 20, null);
        if (!$assertionsDisabled && !(xmin > 0.979)) {
            throw new AssertionError((Object)"xmin > answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin > 0.97902)) {
            throw new AssertionError((Object)"xmin > answer*(1. - 0.001)");
        }
        if (!$assertionsDisabled && !(xmin < 0.981)) {
            throw new AssertionError((Object)"xmin < answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin < 0.9809799999999999)) {
            throw new AssertionError((Object)"xmin < answer*(1. + 0.001)");
        }
        if (!$assertionsDisabled && calls[0] != 12) {
            throw new AssertionError((Object)("calls[0] == 12 != " + calls[0]));
        }
        answer = 0.3333333333333333;
        calls = new int[]{0};
        solver = new ScalarSolver(new Function(){

            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return (scalar - 0.3333333333333333) * (scalar - 0.3333333333333333);
            }
        });
        xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 7, null);
        if (!$assertionsDisabled && !(xmin > 0.3323333333333333)) {
            throw new AssertionError((Object)"xmin > answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin > 0.33299999999999996)) {
            throw new AssertionError((Object)"xmin > answer*(1. - 0.001)");
        }
        if (!$assertionsDisabled && !(xmin < 0.3343333333333333)) {
            throw new AssertionError((Object)"xmin < answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin < 0.3336666666666666)) {
            throw new AssertionError((Object)"xmin < answer*(1. + 0.001)");
        }
        if (!$assertionsDisabled && calls[0] != 6) {
            throw new AssertionError((Object)("Number == 6 != " + calls[0]));
        }
        answer = 0.3333333333333333;
        calls = new int[]{0};
        solver = new ScalarSolver(new Function(){

            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.sqrt(Math.abs(scalar - 0.3333333333333333));
            }
        });
        xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 20, null);
        if (!$assertionsDisabled && !(xmin > 0.3323333333333333)) {
            throw new AssertionError((Object)"xmin > answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin > 0.33299999999999996)) {
            throw new AssertionError((Object)"xmin > answer*(1. - 0.001)");
        }
        if (!$assertionsDisabled && !(xmin < 0.3343333333333333)) {
            throw new AssertionError((Object)"xmin < answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin < 0.3336666666666666)) {
            throw new AssertionError((Object)"xmin < answer*(1. + 0.001)");
        }
        if (!$assertionsDisabled && calls[0] != 16) {
            throw new AssertionError((Object)("Number == 16 != " + calls[0]));
        }
        answer = 0.3333333333333333;
        calls = new int[]{0};
        solver = new ScalarSolver(new Function(){

            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                if (scalar < 0.3333333333333333) {
                    return 3.0;
                }
                return scalar - 0.3333333333333333;
            }
        });
        xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 50, null);
        if (!$assertionsDisabled && !(xmin > 0.3323333333333333)) {
            throw new AssertionError((Object)"xmin > answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin > 0.33299999999999996)) {
            throw new AssertionError((Object)"xmin > answer*(1. - 0.001)");
        }
        if (!$assertionsDisabled && !(xmin < 0.3343333333333333)) {
            throw new AssertionError((Object)"xmin < answer - 0.001");
        }
        if (!$assertionsDisabled && !(xmin < 0.3336666666666666)) {
            throw new AssertionError((Object)"xmin < answer*(1. + 0.001)");
        }
        if (!$assertionsDisabled && calls[0] != 29) {
            throw new AssertionError((Object)("Number == 29 != " + calls[0]));
        }
    }

    static {
        $assertionsDisabled = !ScalarSolver.class.desiredAssertionStatus();
        LOG = Logger.getLogger("com.lgc.wsh.inv");
        GOLD = 0.5 * (Math.sqrt(5.0) - 1.0);
    }

    private static class BadParabolaException
    extends Exception {
        public BadParabolaException(String message) {
            super(message);
        }

        public BadParabolaException() {
        }
    }

    public static interface Function {
        public double function(double var1);
    }
}

