/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Instance;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchClassifierLearner
implements ClassifierLearner {
    public Dataset dataset = new BasicDataset();
    protected Classifier classifier = null;

    @Override
    public ClassifierLearner copy() {
        BatchClassifierLearner bcl = null;
        try {
            bcl = (BatchClassifierLearner)this.clone();
            bcl.dataset = new BasicDataset();
            bcl.classifier = null;
        }
        catch (Exception e) {
            System.out.println("Can't CLONE!!");
            e.printStackTrace();
        }
        return bcl;
    }

    @Override
    public final void reset() {
        this.dataset = new BasicDataset();
        this.classifier = null;
    }

    @Override
    public final void setInstancePool(Iterator<Instance> i) {
    }

    @Override
    public final boolean hasNextQuery() {
        return false;
    }

    @Override
    public final Instance nextQuery() {
        return null;
    }

    @Override
    public final void addExample(Example answeredQuery) {
        this.dataset.add(answeredQuery);
        this.classifier = null;
    }

    @Override
    public final void completeTraining() {
        this.classifier = this.batchTrain(this.dataset);
    }

    @Override
    public final Classifier getClassifier() {
        if (this.classifier == null) {
            this.classifier = this.batchTrain(this.dataset);
        }
        return this.classifier;
    }

    public abstract Classifier batchTrain(Dataset var1);
}

