/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.BatchClassifierLearner;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.OnlineClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.VotedPerceptron;
import edu.cmu.minorthird.util.ProgressCounter;
import java.util.Iterator;

public class BatchVersion
extends BatchClassifierLearner {
    private OnlineClassifierLearner innerLearner;
    private int numberOfEpochs = 1;

    public BatchVersion(OnlineClassifierLearner innerLearner, int numberOfEpochs) {
        this.innerLearner = innerLearner;
        this.numberOfEpochs = numberOfEpochs;
    }

    public BatchVersion(OnlineClassifierLearner innerLearner) {
        this(innerLearner, 1);
    }

    public BatchVersion() {
        this(new VotedPerceptron(), 5);
    }

    public int getNumberOfEpochs() {
        return this.numberOfEpochs;
    }

    public void setNumberOfEpochs(int n) {
        this.numberOfEpochs = n;
    }

    public OnlineClassifierLearner getInnerLearner() {
        return this.innerLearner;
    }

    public void setInnerLearner(OnlineClassifierLearner learner) {
        this.innerLearner = learner;
    }

    public final void setSchema(ExampleSchema schema) {
        this.innerLearner.setSchema(schema);
    }

    public final ExampleSchema getSchema() {
        return this.innerLearner.getSchema();
    }

    public Classifier batchTrain(Dataset dataset) {
        Dataset copy2 = dataset.shallowCopy();
        copy2.shuffle();
        this.innerLearner.reset();
        ProgressCounter pc1 = new ProgressCounter("training " + this.innerLearner.getClass(), "epoch", this.numberOfEpochs);
        for (int i = 0; i < this.numberOfEpochs; ++i) {
            ProgressCounter pc2 = new ProgressCounter("training " + this.innerLearner.getClass(), "example", copy2.size());
            Iterator<Example> j = copy2.iterator();
            while (j.hasNext()) {
                this.innerLearner.addExample(j.next());
                pc2.progress();
            }
            pc2.finished();
            pc1.progress();
        }
        pc1.finished();
        this.innerLearner.completeTraining();
        this.classifier = this.innerLearner.getClassifier();
        return this.classifier;
    }
}

