/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.SampleDatasets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetIndex
implements Serializable {
    static final long serialVersionUID = 20080128L;
    private SortedMap<Feature, List<Example>> indexByFeature = new TreeMap<Feature, List<Example>>();
    private SortedMap<String, List<Example>> indexByClass = new TreeMap<String, List<Example>>();
    private int sumFeatureValues = 0;
    private int exampleCount = 0;

    public DatasetIndex() {
    }

    public DatasetIndex(Dataset data) {
        this();
        Iterator<Example> i = data.iterator();
        while (i.hasNext()) {
            this.addExample(i.next());
        }
    }

    public void addExample(Example e) {
        this.classIndex(e.getLabel().bestClassName()).add(e);
        Iterator<Feature> j = e.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            this.featureIndex(f).add(e);
            ++this.sumFeatureValues;
        }
        ++this.exampleCount;
    }

    public Iterator<Feature> featureIterator() {
        return this.indexByFeature.keySet().iterator();
    }

    public int size(Feature f) {
        return this.featureIndex(f).size();
    }

    public int size(String label) {
        return this.classIndex(label).size();
    }

    public Example getExample(Feature f, int i) {
        return this.featureIndex(f).get(i);
    }

    public Example getExample(String label, int i) {
        return this.classIndex(label).get(i);
    }

    public Iterator<Example> getNeighbors(Instance instance) {
        HashSet<Example> set = new HashSet<Example>();
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            Iterator<Example> j = this.featureIndex(f).iterator();
            while (j.hasNext()) {
                set.add(j.next());
            }
        }
        return set.iterator();
    }

    public int numberOfFeatures() {
        return this.indexByFeature.keySet().size();
    }

    public double averageFeaturesPerExample() {
        return (double)this.sumFeatureValues / (double)this.exampleCount;
    }

    protected List<Example> featureIndex(Feature f) {
        ArrayList result = (ArrayList)this.indexByFeature.get(f);
        if (result == null) {
            result = new ArrayList();
            this.indexByFeature.put(f, result);
        }
        return result;
    }

    protected List<Example> classIndex(String label) {
        ArrayList result = (ArrayList)this.indexByClass.get(label);
        if (result == null) {
            result = new ArrayList();
            this.indexByClass.put(label, result);
        }
        return result;
    }

    public String toString() {
        int j;
        StringBuilder buf = new StringBuilder("[index");
        Iterator<Object> i = this.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            buf.append("\n" + f + ":");
            for (j = 0; j < this.size(f); ++j) {
                buf.append("\n\t" + this.getExample(f, j).toString());
            }
        }
        for (String label : this.indexByClass.keySet()) {
            buf.append("\n" + label + ":");
            for (j = 0; j < this.size(label); ++j) {
                buf.append("\n\t" + this.getExample(label, j).toString());
            }
        }
        buf.append("\nindex]");
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println(new DatasetIndex(SampleDatasets.sampleData("toy", false)));
    }
}

