/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class GUI {
    public static JComponent conciseExampleRendererComponent(Example e, int len, boolean emphasized) {
        if (e == null) {
            return new JTextField("[null example]");
        }
        String sourceString = e.getSource() == null ? "[null]" : StringUtil.truncate(len, e.getSource().toString());
        JTextField tf = new JTextField(e.getLabel() + " " + sourceString);
        Color c = emphasized ? Color.blue : Color.black;
        tf.setBorder(BorderFactory.createLineBorder(c, 2));
        return tf;
    }

    public static Viewer newSourcedExampleViewer() {
        ParallelViewer main = new ParallelViewer();
        main.addSubView("Features", new ExampleViewer());
        main.addSubView("Source", new TransformedViewer(new SmartVanillaViewer()){
            static final long serialVersionUID = 20071015L;

            public Object transform(Object o) {
                return ((Example)o).getSource();
            }
        });
        main.addSubView("Subpopulation", new TransformedViewer(new SmartVanillaViewer()){
            static final long serialVersionUID = 20071015L;

            public Object transform(Object o) {
                return "Subpopulation ID='" + ((Example)o).getSubpopulationId() + "'";
            }
        });
        return main;
    }

    private static JComponent instanceComponent(Instance instance) {
        int numRows = 0;
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            ++numRows;
            i.next();
        }
        Object[][] tableData = new Object[numRows][2];
        int k = 0;
        Iterator<Feature> i2 = instance.featureIterator();
        while (i2.hasNext()) {
            Feature f = i2.next();
            tableData[k][0] = f;
            tableData[k][1] = new Double(instance.getWeight(f));
            ++k;
        }
        Object[] columnNames = new String[]{"Feature Name", "Weight"};
        JTable table = new JTable(tableData, columnNames);
        return new JScrollPane(table);
    }

    public static class InstanceViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20071015L;

        public InstanceViewer() {
        }

        public InstanceViewer(Instance instance) {
            super(instance);
        }

        public boolean canReceive(Object o) {
            return o instanceof Instance;
        }

        public JComponent componentFor(Object o) {
            return GUI.instanceComponent((Instance)o);
        }
    }

    public static class ExampleViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20071015L;

        public ExampleViewer() {
        }

        public ExampleViewer(Example instance) {
            super(instance);
        }

        public boolean canReceive(Object o) {
            return o instanceof Example;
        }

        public JComponent componentFor(Object o) {
            Example e = (Example)o;
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            GridBagConstraints gbc = ExampleViewer.fillerGBC();
            gbc.fill = 2;
            gbc = new GridBagConstraints();
            p.add((Component)new JLabel("Class label: " + e.getLabel().toDetails()), gbc);
            gbc = ExampleViewer.fillerGBC();
            gbc.gridy = 1;
            p.add((Component)GUI.instanceComponent(e), gbc);
            return p;
        }
    }
}

