/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import bsh.EvalError;
import bsh.Interpreter;
import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.ClassifierLearnerFactory;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.OneVsAllClassifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneVsAllLearner
implements ClassifierLearner {
    protected ClassifierLearnerFactory learnerFactory;
    protected ClassifierLearner learner;
    protected String learnerName;
    protected List<ClassifierLearner> innerLearner = null;
    protected ExampleSchema schema;

    static Object newObjectFromBSH(String s, Class<?> expectedType) throws IllegalArgumentException {
        try {
            Object o;
            Interpreter interp = new Interpreter();
            interp.eval("import edu.cmu.minorthird.classify.*;");
            interp.eval("import edu.cmu.minorthird.classify.experiments.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.linear.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.trees.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.knn.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.svm.*;");
            interp.eval("import edu.cmu.minorthird.classify.transform.*;");
            interp.eval("import edu.cmu.minorthird.classify.sequential.*;");
            interp.eval("import edu.cmu.minorthird.text.learn.*;");
            interp.eval("import edu.cmu.minorthird.text.*;");
            interp.eval("import edu.cmu.minorthird.ui.*;");
            interp.eval("import edu.cmu.minorthird.util.*;");
            if (!s.startsWith("new")) {
                s = "new " + s;
            }
            if (!expectedType.isInstance(o = interp.eval(s))) {
                throw new IllegalArgumentException(s + " did not produce " + expectedType);
            }
            return o;
        }
        catch (EvalError e) {
            System.out.println("ERROR: " + e.toString());
            throw new IllegalArgumentException("error parsing '" + s + "':\n" + e);
        }
    }

    public OneVsAllLearner() {
        this("new MaxEntLearner()");
    }

    public OneVsAllLearner(ClassifierLearnerFactory learnerFactory) {
        this.learnerFactory = learnerFactory;
    }

    public OneVsAllLearner(String learnerName) {
        this.learnerName = learnerName;
        this.learnerFactory = new ClassifierLearnerFactory(learnerName);
        try {
            this.learner = (ClassifierLearner)OneVsAllLearner.newObjectFromBSH(learnerName, ClassifierLearner.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OneVsAllLearner(ClassifierLearner learner) {
        this.learner = learner;
        this.learnerName = learner.toString();
        this.learnerFactory = new ClassifierLearnerFactory(this.learnerName);
    }

    public void setInnerLearner(ClassifierLearner learner) {
        this.learner = learner;
    }

    public ClassifierLearner getInnerLearner() {
        return this.learner;
    }

    @Override
    public ClassifierLearner copy() {
        OneVsAllLearner learner = null;
        try {
            learner = (OneVsAllLearner)this.clone();
            if (this.innerLearner != null) {
                learner.innerLearner.clear();
                for (int i = 0; i < this.innerLearner.size(); ++i) {
                    ClassifierLearner inner = this.innerLearner.get(i);
                    learner.innerLearner.add(inner.copy());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Can't clone!");
            e.printStackTrace();
        }
        return learner;
    }

    @Override
    public void setSchema(ExampleSchema schema) {
        this.schema = schema;
        this.innerLearner = new ArrayList<ClassifierLearner>();
        for (int i = 0; i < schema.getNumberOfClasses(); ++i) {
            this.innerLearner.add(this.learner.copy());
            this.innerLearner.get(i).setSchema(ExampleSchema.BINARY_EXAMPLE_SCHEMA);
        }
    }

    @Override
    public ExampleSchema getSchema() {
        return this.schema;
    }

    @Override
    public void reset() {
        if (this.innerLearner != null) {
            for (int i = 0; i < this.innerLearner.size(); ++i) {
                this.innerLearner.get(i).reset();
            }
        }
    }

    @Override
    public void setInstancePool(Iterator<Instance> iterator) {
        ArrayList<Instance> list = new ArrayList<Instance>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            this.innerLearner.get(i).setInstancePool(list.iterator());
        }
    }

    @Override
    public boolean hasNextQuery() {
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            if (!this.innerLearner.get(i).hasNextQuery()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Instance nextQuery() {
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            if (!this.innerLearner.get(i).hasNextQuery()) continue;
            return this.innerLearner.get(i).nextQuery();
        }
        return null;
    }

    @Override
    public void addExample(Example answeredQuery) {
        int classIndex = this.schema.getClassIndex(answeredQuery.getLabel().bestClassName());
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            ClassLabel label = classIndex == i ? ClassLabel.positiveLabel(1.0) : ClassLabel.negativeLabel(-1.0);
            this.innerLearner.get(i).addExample(new Example(answeredQuery.asInstance(), label));
        }
    }

    @Override
    public void completeTraining() {
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            this.innerLearner.get(i).completeTraining();
        }
    }

    @Override
    public Classifier getClassifier() {
        Classifier[] classifiers = new Classifier[this.innerLearner.size()];
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            classifiers[i] = this.innerLearner.get(i).getClassifier();
        }
        return new OneVsAllClassifier(this.schema.validClassNames(), classifiers);
    }

    public static class IllegalArgumentException
    extends Exception {
        static final long serialVersionUID = 20071015L;

        public IllegalArgumentException(String s) {
            super(s);
        }
    }
}

