/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.random;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Estimate {
    private String model;
    private String parameterization;
    private SortedMap<String, Double> pms;

    public Estimate(String mod, String param, SortedMap<String, Double> pms) {
        this.model = mod;
        this.parameterization = param;
        this.pms = pms;
    }

    public String getModel() {
        return this.model;
    }

    public String getParameterization() {
        return this.parameterization;
    }

    public SortedMap<String, Double> getPms() {
        return this.pms;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[ ");
        buf.append("model=" + this.model + ", " + "parameterization=" + this.parameterization + " : ");
        Set<String> names = this.pms.keySet();
        for (String key : names) {
            double value = (Double)this.pms.get(key);
            buf.append(key + "=" + value + ", ");
        }
        buf.delete(buf.length() - 2, buf.length());
        buf.append(" ]");
        return buf.toString();
    }

    public String toTableInViewer() {
        StringBuffer buf = new StringBuffer("");
        buf.append(this.model);
        Set<String> names = this.pms.keySet();
        for (String key : names) {
            double value = (Double)this.pms.get(key);
            buf.append(", " + key + "=" + value);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        TreeMap<String, Double> mudelta = new TreeMap<String, Double>();
        mudelta.put("mu", new Double(0.661));
        mudelta.put("delta", new Double(0.035));
        Estimate theta = new Estimate("Binomial", "mu/delta", mudelta);
        System.out.println(theta.toString());
        System.out.println("|" + theta.toTableInViewer() + "|");
        TreeMap<String, Double> pn = new TreeMap<String, Double>();
        pn.put("p", new Double(0.661));
        pn.put("N", new Double(11.0));
        Estimate gamma = new Estimate("Binomial", "p/N", pn);
        System.out.println(gamma.toString());
        System.out.println("|" + gamma.toTableInViewer() + "|");
    }
}

