/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import bsh.EvalError;
import bsh.Interpreter;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetClassifierTeacher;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.CrossValSplitter;
import edu.cmu.minorthird.classify.experiments.CrossValidatedDataset;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.classify.experiments.FixedTestSetSplitter;
import edu.cmu.minorthird.classify.experiments.LeaveOneOutSplitter;
import edu.cmu.minorthird.classify.experiments.RandomSplitter;
import edu.cmu.minorthird.classify.experiments.Tester;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expt
implements CommandLineProcessor.Configurable {
    private Dataset trainData = null;
    private Dataset testData = null;
    private Splitter<Example> splitter = null;
    private ClassifierLearner learner = null;
    private String splitterArg = null;
    private String trainArg = null;
    private String testArg = null;
    private String learnerArg = null;

    @Override
    public CommandLineProcessor getCLP() {
        return new MyCLP();
    }

    public Expt(ClassifierLearner learner, Dataset trainData, Dataset testData) {
        this.learner = learner;
        this.trainData = trainData;
        this.testData = testData;
        this.splitter = null;
    }

    public Expt(ClassifierLearner learner, Dataset trainData, Splitter<Example> splitter) {
        this.learner = learner;
        this.trainData = trainData;
        this.splitter = splitter;
    }

    public Expt(String[] args) throws IOException {
        int pos = 0;
        while (pos < args.length) {
            String opt;
            if ((opt = args[pos++]).startsWith("-tr")) {
                this.trainArg = args[pos++];
                this.trainData = Expt.toDataset(this.trainArg);
                continue;
            }
            if (opt.startsWith("-te")) {
                if (this.splitter != null) {
                    throw new IllegalArgumentException("only one of splitter, testData allowed");
                }
                this.testArg = args[pos++];
                this.testData = Expt.toDataset(this.testArg);
                this.splitter = new FixedTestSetSplitter<Example>(this.testData.iterator());
                continue;
            }
            if (opt.startsWith("-spl")) {
                if (this.splitter != null) {
                    throw new IllegalArgumentException("only one of splitter, testData allowed");
                }
                this.splitterArg = args[pos++];
                this.splitter = Expt.toSplitter(this.splitterArg);
                continue;
            }
            if (opt.startsWith("-lea")) {
                this.learnerArg = args[pos++];
                this.learner = Expt.toLearner(this.learnerArg);
                continue;
            }
            if (!opt.startsWith("-")) continue;
            ++pos;
        }
        if (this.trainData == null || this.learner == null) {
            throw new IllegalArgumentException("learner and trainData must be specified");
        }
        if (this.testData == null && this.splitter == null) {
            this.splitter = new FixedTestSetSplitter<Example>(this.trainData.iterator());
        }
    }

    public Evaluation evaluation() {
        Evaluation v = Tester.evaluate(this.learner, this.trainData, this.splitter);
        v.setProperty("learner", this.learnerArg);
        v.setProperty("train", this.trainArg);
        if (this.splitterArg != null) {
            v.setProperty("splitter", this.splitterArg);
        }
        if (this.testArg != null) {
            v.setProperty("test", this.testArg);
        }
        return v;
    }

    public CrossValidatedDataset crossValidatedDataset(boolean saveTrain) {
        return new CrossValidatedDataset(this.learner, this.trainData, this.splitter, saveTrain);
    }

    public Classifier getClassifier() {
        return new DatasetClassifierTeacher(this.trainData).train(this.learner);
    }

    public String toString() {
        return "[Expt:\n  learner:" + this.learner + "\n  splitter:" + this.splitter + "\n  train:\n" + this.trainData + "  test:\n" + this.testData + "Expt]";
    }

    public static <T> Splitter<T> toSplitter(String splitterName, Class<T> clazz) {
        if (splitterName.charAt(0) == 'k') {
            int folds = StringUtil.atoi(splitterName.substring(1, splitterName.length()));
            return new CrossValSplitter(folds);
        }
        if (splitterName.charAt(0) == 'r') {
            double pct = (double)StringUtil.atoi(splitterName.substring(1, splitterName.length())) / 100.0;
            return new RandomSplitter(pct);
        }
        if (splitterName.startsWith("l")) {
            return new LeaveOneOutSplitter();
        }
        throw new IllegalArgumentException("illegal splitterName '" + splitterName + "'");
    }

    public static Splitter<Example> toSplitter(String splitterName) {
        return Expt.toSplitter(splitterName, Example.class);
    }

    public static Dataset toDataset(String datasetName) throws IOException {
        String[] words = datasetName.split("\\:");
        if (words.length == 1) {
            return DatasetLoader.loadFile(new File(words[0]));
        }
        if (words.length == 2 && "file".equals(words[0])) {
            return DatasetLoader.loadFile(new File(words[1]));
        }
        if (words.length == 2 && "seqfile".equals(words[0])) {
            return DatasetLoader.loadSequence(new File(words[1]));
        }
        if ("sample".equals(words[0])) {
            String[] parts = words[1].split("\\.");
            if (parts.length == 1) {
                return SampleDatasets.sampleData(parts[0], false);
            }
            if ("test".equals(parts[1])) {
                return SampleDatasets.sampleData(parts[0], true);
            }
            if ("train".equals(parts[1])) {
                return SampleDatasets.sampleData(parts[0], false);
            }
        }
        throw new IllegalArgumentException("illegal datasetName: " + datasetName);
    }

    public static ClassifierLearner toLearner(String learnerName) {
        try {
            Interpreter interp = new Interpreter();
            interp.eval("import edu.cmu.minorthird.classify.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.linear.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.trees.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.ranking.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.knn.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.svm.*;");
            interp.eval("import edu.cmu.minorthird.classify.transform.*;");
            interp.eval("import edu.cmu.minorthird.classify.semisupervised.*;");
            return (ClassifierLearner)interp.eval(learnerName);
        }
        catch (EvalError e) {
            throw new IllegalArgumentException("error parsing learnerName '" + learnerName + "':\n" + e);
        }
    }

    public static void main(String[] args) {
        try {
            Expt expt = new Expt(args);
            int pos = 0;
            Serializable toSave = null;
            File saveFile = null;
            while (pos < args.length) {
                String what;
                String opt;
                if ((opt = args[pos++]).startsWith("-show")) {
                    if ((what = args[pos++]).startsWith("eval")) {
                        Evaluation v = expt.evaluation();
                        new ViewerFrame("Evaluation", v.toGUI());
                        continue;
                    }
                    if (what.startsWith("all")) {
                        boolean saveTrain = "all+".equals(what);
                        CrossValidatedDataset cdv = expt.crossValidatedDataset(saveTrain);
                        new ViewerFrame("CrossValidatedDataset", cdv.toGUI());
                        continue;
                    }
                    throw new IllegalArgumentException("can't show '" + what + "'");
                }
                if (opt.startsWith("-save")) {
                    if ((what = args[pos++]).startsWith("eval")) {
                        toSave = expt.evaluation();
                        continue;
                    }
                    if (what.startsWith("cla")) {
                        toSave = (Serializable)((Object)expt.getClassifier());
                        continue;
                    }
                    throw new IllegalArgumentException("can't save '" + what + "'");
                }
                if (opt.startsWith("-file")) {
                    saveFile = new File(args[pos++]);
                    continue;
                }
                if (!opt.startsWith("-")) continue;
                ++pos;
            }
            if (saveFile != null && toSave != null) {
                IOUtil.saveSerialized(toSave, saveFile);
            }
            if (saveFile == null != (toSave == null)) {
                throw new IllegalArgumentException("must specify -file FILE with -save WHAT");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: -learn L -train D1 [-split S] [-test D] [-show eval|all|all+] [-save eval|classifier]");
        }
    }

    private class MyCLP
    extends BasicCommandLineProcessor {
        private MyCLP() {
        }

        public void train(String s) {
            try {
                Expt.this.trainData = Expt.toDataset(s);
                Expt.this.trainArg = s;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Error loading " + s + ": " + ex);
            }
        }

        public void test(String s) {
            try {
                Expt.this.testData = Expt.toDataset(s);
                Expt.this.splitter = new FixedTestSetSplitter<Example>(Expt.this.testData.iterator());
                Expt.this.testArg = s;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Error loading " + s + ": " + ex);
            }
        }

        public void splitter(String s) {
            Expt.this.splitterArg = s;
            Expt.this.splitter = Expt.toSplitter(s);
        }

        public void learner(String s) {
            Expt.this.learner = Expt.toLearner(s);
            Expt.this.learnerArg = s;
        }

        public void usage() {
            System.out.println("classify.Expt parameters:");
            System.out.println(" -train FILE              training data is in FILE");
            System.out.println(" [-test FILE]             test data is in FILE");
            System.out.println(" [-splitter SPLITTER]     do cross-validation study with the SPLITTER");
            System.out.println(" [-learner LEARNER]       use learner defined by bean-shell command");
            System.out.println();
        }
    }
}

