/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.Splitter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRandomSplitter<T>
implements Splitter<T> {
    private Random random;
    private double trainFraction;
    private List<T> trainList = null;
    private List<T> testList = null;

    public SimpleRandomSplitter(Random random2, double trainFraction) {
        this.random = random2;
        this.trainFraction = trainFraction;
    }

    public SimpleRandomSplitter(double trainFraction) {
        this(new Random(), trainFraction);
    }

    public SimpleRandomSplitter() {
        this(0.7);
    }

    @Override
    public void split(Iterator<T> i) {
        this.trainList = new ArrayList<T>();
        this.testList = new ArrayList<T>();
        while (i.hasNext()) {
            T t = i.next();
            if (this.random.nextDouble() <= this.trainFraction) {
                this.trainList.add(t);
                continue;
            }
            this.testList.add(t);
        }
    }

    @Override
    public int getNumPartitions() {
        return 1;
    }

    @Override
    public Iterator<T> getTrain(int k) {
        return this.trainList.iterator();
    }

    @Override
    public Iterator<T> getTest(int k) {
        return this.testList.iterator();
    }
}

