/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.relational;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.SGMExample;
import edu.cmu.minorthird.classify.SGMFeatureFactory;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.classify.relational.Link;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreRelationalDataset
extends BasicDataset
implements Visible,
Saveable,
Dataset,
Serializable {
    static final long serialVersionUID = 20080128L;
    protected static Map<String, Map<String, Set<String>>> linksMap = new HashMap<String, Map<String, Set<String>>>();
    protected SGMFeatureFactory factory = new SGMFeatureFactory();

    public void addSGM(SGMExample example) {
        this.addSGM(example, true);
    }

    public void addSGM(SGMExample example, boolean compress) {
        if (compress) {
            this.examples.add(this.factory.compressSGM(example));
        } else {
            this.examples.add(example);
        }
        this.classNameSet.addAll(example.getLabel().possibleLabels());
    }

    public static void addLink(Link link) {
        String from = link.getFrom();
        String to = link.getTo();
        String type = link.getType();
        if (linksMap.containsKey(from)) {
            if (linksMap.get(from).containsKey(type)) {
                linksMap.get(from).get(type).add(to);
            } else {
                HashSet<String> set = new HashSet<String>();
                set.add(to);
                linksMap.get(from).put(type, (Set)set.clone());
            }
        } else {
            HashMap<String, Set> map = new HashMap<String, Set>();
            HashSet<String> set = new HashSet<String>();
            set.add(to);
            map.put(type, (Set)set.clone());
            linksMap.put(from, (Map)map.clone());
        }
    }

    public SGMExample getExampleWithID(String id) {
        for (SGMExample e : this.examples) {
            if (!e.hasID(id)) continue;
            return e;
        }
        return null;
    }

    public static Map<String, Map<String, Set<String>>> getLinksMap() {
        return linksMap;
    }

    public static void setLinksMap(Map<String, Map<String, Set<String>>> linksMap) {
        CoreRelationalDataset.linksMap = linksMap;
    }

    public static void main(String[] args) {
        try {
            BasicDataset data = (BasicDataset)SampleDatasets.sampleData("toy", false);
            System.out.println(data.getSchema());
            CoreRelationalDataset.addLink(new Link("1", "2", "left"));
            CoreRelationalDataset.addLink(new Link("1", "3", "left"));
            CoreRelationalDataset.addLink(new Link("2", "3", "left"));
            System.out.println(linksMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

