/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.sequential.BatchSequenceClassifierLearner;
import edu.cmu.minorthird.classify.sequential.CollinsPerceptronLearner;
import edu.cmu.minorthird.classify.sequential.HMM;
import edu.cmu.minorthird.classify.sequential.MultiClassHMMClassifier;
import edu.cmu.minorthird.classify.sequential.SequenceClassifier;
import edu.cmu.minorthird.classify.sequential.SequenceConstants;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import org.apache.log4j.Logger;

public class HMMLearner
implements BatchSequenceClassifierLearner,
SequenceConstants {
    protected int historySize;
    protected String[] history;
    int numClasses;
    HMM hmmModel;
    protected static Logger log = Logger.getLogger(CollinsPerceptronLearner.class);
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected int numberOfEpochs;

    public int getHistorySize() {
        return 1;
    }

    public HMMLearner(int historySize) {
        this.historySize = historySize;
        this.history = new String[historySize];
    }

    public HMMLearner() {
        this(0);
    }

    public int getNumberOfEpochs() {
        return this.numberOfEpochs;
    }

    public void setNumberOfEpochs(int newNumberOfEpochs) {
        this.numberOfEpochs = newNumberOfEpochs;
    }

    public void setSchema(ExampleSchema schema) {
    }

    public SequenceClassifier batchTrain(SequenceDataset dataset) {
        System.out.println("\nbatch train is called\n");
        ExampleSchema schema = dataset.getSchema();
        this.numClasses = schema.getNumberOfClasses();
        MultiClassHMMClassifier hmm = new MultiClassHMMClassifier(dataset);
        hmm.baumwelch(1.0E-5);
        return hmm;
    }
}

