/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperplaneInstance
implements Instance {
    private Hyperplane hyperplane;
    private String subpopulationId;
    private Object source;

    public HyperplaneInstance(Hyperplane hyperplane, String subpopulationId, Object source) {
        hyperplane.incrementBias(-1.0);
        this.hyperplane = hyperplane;
        this.subpopulationId = subpopulationId;
        this.source = source;
    }

    @Override
    public Viewer toGUI() {
        ComponentViewer v = new ComponentViewer(){
            static final long serialVersionUID = 20080202L;

            public JComponent componentFor(Object o) {
                HyperplaneInstance hi = (HyperplaneInstance)o;
                return hi.hyperplane.toGUI();
            }
        };
        v.setContent(this);
        return v;
    }

    @Override
    public double getWeight(Feature f) {
        return this.hyperplane.featureScore(f);
    }

    @Override
    public Iterator<Feature> binaryFeatureIterator() {
        return Collections.EMPTY_SET.iterator();
    }

    @Override
    public Iterator<Feature> numericFeatureIterator() {
        return this.hyperplane.featureIterator();
    }

    @Override
    public Iterator<Feature> featureIterator() {
        return this.hyperplane.featureIterator();
    }

    @Override
    public int numFeatures() {
        throw new UnsupportedOperationException();
    }

    public double getWeight() {
        return 1.0;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public String getSubpopulationId() {
        return this.subpopulationId;
    }
}

