/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.sequential.SequenceConstants;
import edu.cmu.minorthird.util.UnionIterator;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceFromSequence
implements Instance,
SequenceConstants {
    private Instance instance;
    private Set<Feature> history;

    public InstanceFromSequence(Instance instance, String[] previousLabels) {
        this.instance = instance;
        this.history = new HashSet<Feature>();
        for (int i = 0; i < previousLabels.length; ++i) {
            this.history.add(new Feature(new String[]{"previousLabel", Integer.toString(i + 1), previousLabels[i]}));
        }
    }

    public Instance asPlainInstance() {
        return this.instance;
    }

    @Override
    public final Object getSource() {
        return this.instance.getSource();
    }

    @Override
    public final String getSubpopulationId() {
        return this.instance.getSubpopulationId();
    }

    @Override
    public final Iterator<Feature> numericFeatureIterator() {
        return this.instance.numericFeatureIterator();
    }

    @Override
    public final Iterator<Feature> binaryFeatureIterator() {
        return new UnionIterator<Feature>(this.history.iterator(), this.instance.binaryFeatureIterator());
    }

    @Override
    public final Iterator<Feature> featureIterator() {
        return new UnionIterator<Feature>(this.history.iterator(), this.instance.featureIterator());
    }

    @Override
    public final int numFeatures() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final double getWeight(Feature f) {
        if (this.history.contains(f)) {
            return 1.0;
        }
        return this.instance.getWeight(f);
    }

    public String toString() {
        return "[instFromSeq " + this.history + " " + this.instance + "]";
    }

    @Override
    public final Viewer toGUI() {
        return new GUI.InstanceViewer(this);
    }

    public static void fillHistory(String[] history, Example[] sequence, int j) {
        for (int k = 0; k < history.length; ++k) {
            history[k] = j - k - 1 >= 0 ? sequence[j - k - 1].getLabel().bestClassName() : "null";
        }
    }

    public static void fillHistory(String[] history, ClassLabel[] labels, int j) {
        for (int k = 0; k < history.length; ++k) {
            history[k] = j - k - 1 >= 0 ? labels[j - k - 1].bestClassName() : "null";
        }
    }

    public static void fillHistory(String[] history, String[] labels, int j) {
        for (int k = 0; k < history.length; ++k) {
            history[k] = j - k - 1 >= 0 ? labels[j - k - 1] : "null";
        }
    }

    public static void main(String[] argv) {
        MutableInstance instance = new MutableInstance("William Cohen");
        instance.addBinary(new Feature("token lc william"));
        instance.addBinary(new Feature("token lc cohen"));
        instance.addNumeric(new Feature("iq"), 250.0);
        instance.addNumeric(new Feature("office"), 5317.0);
        InstanceFromSequence inseq = new InstanceFromSequence(instance, new String[]{"dweeb", "cool", "cool"});
        new ViewerFrame("TestInstance Viewer", inseq.toGUI());
    }
}

