/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.sequential.CandidateSegmentGroup;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableCandidateSegmentGroup
implements CandidateSegmentGroup {
    private int maxWindowSize;
    private int sequenceLength;
    private Instance[][] window;
    private ClassLabel[][] label;
    private int totalSize;
    private String subPopId = null;

    public MutableCandidateSegmentGroup(int maxWindowSize, int sequenceLength) {
        this.sequenceLength = sequenceLength;
        this.maxWindowSize = maxWindowSize;
        this.window = new Instance[sequenceLength][maxWindowSize];
        this.label = new ClassLabel[sequenceLength][maxWindowSize];
        this.totalSize = 0;
    }

    public void setSubsequence(int start, int end, Instance newInstance, ClassLabel newLabel) {
        this.setSubPopId(newInstance.getSubpopulationId());
        if (this.window[start][end - start - 1] == null) {
            ++this.totalSize;
        }
        this.window[start][end - start - 1] = newInstance;
        this.label[start][end - start - 1] = newLabel;
    }

    public void setSubsequence(int start, int end, Instance newInstance) {
        this.setSubPopId(newInstance.getSubpopulationId());
        this.window[start][end - start - 1] = newInstance;
    }

    private void setSubPopId(String newSubpopId) {
        if (this.subPopId != null && !this.subPopId.equals(newSubpopId)) {
            throw new IllegalArgumentException("grouping instances with different subPopId?");
        }
        this.subPopId = newSubpopId;
    }

    @Override
    public Example getSubsequenceExample(int start, int end) {
        if (this.window[start][end - start - 1] != null) {
            return new Example(this.window[start][end - start - 1], this.label[start][end - start - 1]);
        }
        return null;
    }

    @Override
    public ClassLabel getSubsequenceLabel(int start, int end) {
        return this.label[start][end - start - 1];
    }

    @Override
    public Instance getSubsequenceInstance(int start, int end) {
        return this.window[start][end - start - 1];
    }

    @Override
    public int getSequenceLength() {
        return this.sequenceLength;
    }

    @Override
    public int getMaxWindowSize() {
        return this.maxWindowSize;
    }

    @Override
    public String getSubpopulationId() {
        return this.subPopId;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public Set<String> classNameSet() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.label.length; ++i) {
            for (int j = 0; j < this.label[i].length; ++j) {
                if (this.label[i][j] == null) continue;
                result.addAll(this.label[i][j].possibleLabels());
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        for (int lo = 0; lo < this.window.length; ++lo) {
            for (int len = 1; len <= this.maxWindowSize; ++len) {
                buf.append(lo + ".." + (lo + len) + ": ");
                if (this.window[lo][len - 1] == null) {
                    buf.append("NULL");
                } else {
                    buf.append(this.window[lo][len - 1].toString());
                    if (this.label[lo][len - 1] != null) {
                        buf.append(";" + this.label[lo][len - 1]);
                    }
                }
                buf.append("\n");
            }
        }
        return buf.toString();
    }
}

