/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.FeatureFactory;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.sequential.CandidateSegmentGroup;
import edu.cmu.minorthird.classify.sequential.CompactCandidateSegmentGroup;
import edu.cmu.minorthird.classify.sequential.MutableCandidateSegmentGroup;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ZoomedViewer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentDataset
implements Dataset {
    int maxWindowSize = -1;
    private List<CandidateSegmentGroup> groupList = new ArrayList<CandidateSegmentGroup>();
    private Set<String> classNameSet = new HashSet<String>();
    private int totalSize = 0;
    private FeatureFactory factory = new FeatureFactory();
    private boolean compressGroups = true;

    public void setDataCompression(boolean flag) {
        this.compressGroups = flag;
    }

    @Override
    public FeatureFactory getFeatureFactory() {
        return this.factory;
    }

    public int getMaxWindowSize() {
        return this.maxWindowSize;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    public int getNumberOfSegmentGroups() {
        return this.groupList.size();
    }

    public void addCandidateSegmentGroup(CandidateSegmentGroup group) {
        if (this.maxWindowSize < 0) {
            this.maxWindowSize = group.getMaxWindowSize();
        }
        if (this.maxWindowSize >= 0 && group.getMaxWindowSize() != this.maxWindowSize) {
            throw new IllegalArgumentException("mismatched window sizes: " + this.maxWindowSize + ", " + group.getMaxWindowSize());
        }
        if (this.compressGroups) {
            this.groupList.add(new CompactCandidateSegmentGroup(this.factory, group));
        } else {
            this.groupList.add(group);
        }
        this.classNameSet.addAll(group.classNameSet());
        this.totalSize += group.size();
    }

    @Override
    public ExampleSchema getSchema() {
        ExampleSchema schema = new ExampleSchema(this.classNameSet.toArray(new String[this.classNameSet.size()]));
        if (schema.equals(ExampleSchema.BINARY_EXAMPLE_SCHEMA)) {
            return ExampleSchema.BINARY_EXAMPLE_SCHEMA;
        }
        return schema;
    }

    @Override
    public void add(Example example) {
        this.add(example, false);
    }

    @Override
    public void add(Example example, boolean compress) {
        MutableCandidateSegmentGroup g = new MutableCandidateSegmentGroup(1, 1);
        if (compress) {
            g.setSubsequence(0, 1, this.factory.compress(example.asInstance()), example.getLabel());
        } else {
            g.setSubsequence(0, 1, example.asInstance(), example.getLabel());
        }
        this.addCandidateSegmentGroup(g);
    }

    @Override
    public Iterator<Example> iterator() {
        ArrayList<Example> result = new ArrayList<Example>();
        for (CandidateSegmentGroup g : this.groupList) {
            for (int j = 0; j < g.getSequenceLength(); ++j) {
                for (int k = 1; k <= g.getMaxWindowSize(); ++k) {
                    Example e = g.getSubsequenceExample(j, j + k);
                    if (e == null) continue;
                    result.add(e);
                }
            }
        }
        return result.iterator();
    }

    public Iterator<CandidateSegmentGroup> candidateSegmentGroupIterator() {
        return this.groupList.iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        buf.append("size = " + this.size() + "\n");
        Iterator<CandidateSegmentGroup> i = this.groupList.iterator();
        while (i.hasNext()) {
            buf.append(i.next() + "\n");
        }
        return buf.toString();
    }

    @Override
    public void shuffle(Random r) {
        Collections.shuffle(this.groupList, r);
    }

    @Override
    public void shuffle() {
        Collections.shuffle(this.groupList, new Random(0L));
    }

    @Override
    public Dataset shallowCopy() {
        SegmentDataset copy2 = new SegmentDataset();
        Iterator<CandidateSegmentGroup> i = this.groupList.iterator();
        while (i.hasNext()) {
            copy2.addCandidateSegmentGroup(i.next());
        }
        return copy2;
    }

    @Override
    public Dataset.Split split(Splitter<Example> splitter) {
        throw new UnsupportedOperationException();
    }

    public Dataset.Split splitCandidateSegmentGroup(final Splitter<CandidateSegmentGroup> splitter) {
        splitter.split(this.groupList.iterator());
        return new Dataset.Split(){

            public int getNumPartitions() {
                return splitter.getNumPartitions();
            }

            public Dataset getTrain(int k) {
                return SegmentDataset.this.invertIteration(splitter.getTrain(k));
            }

            public Dataset getTest(int k) {
                return SegmentDataset.this.invertIteration(splitter.getTest(k));
            }
        };
    }

    protected Dataset invertIteration(Iterator<CandidateSegmentGroup> i) {
        SegmentDataset copy2 = new SegmentDataset();
        while (i.hasNext()) {
            CandidateSegmentGroup o = i.next();
            copy2.addCandidateSegmentGroup(o);
        }
        return copy2;
    }

    @Override
    public Viewer toGUI() {
        BasicDataset.SimpleDatasetViewer dbGui = new BasicDataset.SimpleDatasetViewer();
        dbGui.setContent(this);
        Viewer instGui = GUI.newSourcedExampleViewer();
        return new ZoomedViewer(dbGui, instGui);
    }

    public int getNumPosExamples() {
        return -1;
    }
}

