/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.sequential.CandidateSegmentGroup;
import edu.cmu.minorthird.classify.sequential.MutableCandidateSegmentGroup;
import edu.cmu.minorthird.classify.sequential.SegmentDataset;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.util.ProgressCounter;
import java.util.Iterator;

class SegmentTransform {
    private InstanceTransform innerTransform;

    public SegmentTransform(InstanceTransform innerTransform) {
        this.innerTransform = innerTransform;
    }

    public SegmentDataset transform(SegmentDataset dataset) {
        ProgressCounter pc = new ProgressCounter("adding dictionary distances", "segment group", dataset.getNumberOfSegmentGroups());
        SegmentDataset transformed = new SegmentDataset();
        Iterator<CandidateSegmentGroup> i = dataset.candidateSegmentGroupIterator();
        while (i.hasNext()) {
            transformed.addCandidateSegmentGroup(this.transform(i.next()));
            pc.progress();
        }
        pc.finished();
        return transformed;
    }

    public CandidateSegmentGroup transform(CandidateSegmentGroup g) {
        MutableCandidateSegmentGroup result = new MutableCandidateSegmentGroup(g.getMaxWindowSize(), g.getSequenceLength());
        for (int lo = 0; lo < g.getSequenceLength(); ++lo) {
            for (int len = 1; len <= g.getMaxWindowSize(); ++len) {
                Instance gInstance = g.getSubsequenceInstance(lo, lo + len);
                if (gInstance == null) continue;
                Instance tInstance = this.innerTransform.transform(gInstance);
                result.setSubsequence(lo, lo + len, tInstance, g.getSubsequenceLabel(lo, lo + len));
            }
        }
        return result;
    }
}

