/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.ExampleSchema;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segmentation {
    private TreeSet<Segment> segments = new TreeSet();
    private ExampleSchema schema;

    public Segmentation(ExampleSchema schema) {
        this.schema = schema;
    }

    public void add(Segment seg) {
        this.segments.add(seg);
    }

    public boolean contains(Segment seg) {
        return this.segments.contains(seg);
    }

    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    public int size() {
        return this.segments.size();
    }

    public String className(Segment seg) {
        String name = this.schema.getClassName(seg.y);
        return "NEG".equals(name) ? null : name;
    }

    public String toString() {
        return "[Segmentation: " + this.segments + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Segment
    implements Comparable<Segment> {
        public final int lo;
        public final int hi;
        public final int y;

        public Segment(int lo, int hi, int y) {
            this.lo = lo;
            this.hi = hi;
            this.y = y;
        }

        @Override
        public int compareTo(Segment b) {
            int cmp = this.lo - b.lo;
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.hi - b.hi;
            if (cmp != 0) {
                return cmp;
            }
            return this.y - b.y;
        }

        public String toString() {
            return "[Segment " + this.lo + ".." + this.hi + ";" + this.y + "]";
        }
    }
}

