/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.transform.AbstractInstanceTransform;
import edu.cmu.minorthird.classify.transform.MaskedInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChiSquareInstanceTransform
extends AbstractInstanceTransform {
    private int TOP_FEATURES;
    private List<Pair> featValues;
    private Set<Feature> availableFeatures = new HashSet<Feature>();
    private boolean isSorted;
    final Comparator<Pair> VAL_COMPARATOR = new Comparator<Pair>(){

        @Override
        public int compare(Pair ig1, Pair ig2) {
            if (ig1.value < ig2.value) {
                return 1;
            }
            if (ig1.value > ig2.value) {
                return -1;
            }
            return ig1.feature.compareTo(ig2.feature);
        }
    };

    public ChiSquareInstanceTransform() {
        this.TOP_FEATURES = 100;
        this.featValues = new ArrayList<Pair>();
    }

    public ChiSquareInstanceTransform(int num) {
        this.TOP_FEATURES = num;
        this.featValues = new ArrayList<Pair>();
    }

    public Instance transform(Instance ins) {
        if (!this.isSorted) {
            Collections.sort(this.featValues, this.VAL_COMPARATOR);
            this.isSorted = true;
            int maxIndex = Math.min(this.featValues.size(), this.TOP_FEATURES);
            for (int j = 0; j < maxIndex; ++j) {
                this.availableFeatures.add(this.featValues.get((int)j).feature);
            }
        }
        return new MaskedInstance(ins, this.availableFeatures);
    }

    public String toString(int top) {
        Collections.sort(this.featValues, this.VAL_COMPARATOR);
        int maxIndex = Math.min(this.featValues.size(), top);
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < maxIndex; ++j) {
            Feature f = this.featValues.get((int)j).feature;
            double val = this.featValues.get((int)j).value;
            sb.append(f.toString() + " , " + val + "\n");
        }
        return sb.toString();
    }

    public Feature[] getTopFeatures(int top) {
        Collections.sort(this.featValues, this.VAL_COMPARATOR);
        int maxIndex = Math.min(this.featValues.size(), top);
        Feature[] ff = new Feature[maxIndex];
        for (int j = 0; j < maxIndex; ++j) {
            ff[j] = this.featValues.get((int)j).feature;
        }
        return ff;
    }

    public void setNumberOfFeatures(int number) {
        this.TOP_FEATURES = number;
        this.isSorted = false;
    }

    public void addFeature(double infoGain, Feature f) {
        Pair p = new Pair(infoGain, f);
        this.featValues.add(p);
        this.isSorted = false;
    }

    private class Pair {
        double value;
        Feature feature;

        public Pair(double v, Feature f) {
            this.value = v;
            this.feature = f;
        }

        public String toString() {
            return "[ " + this.value + "," + this.feature + " ]";
        }
    }
}

