/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.classify.transform.MaskedInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class InfoGainInstanceTransform
implements InstanceTransform {
    private int TOP_FEATURES = 100;
    private List<Pair> igValues = new ArrayList<Pair>();

    public Instance transform(Instance instance) {
        System.out.println("Warning: cannot transform instance with Info-Gain!");
        return instance;
    }

    public Example transform(Example example) {
        System.out.println("Warning: cannot transform example with Info-Gain!");
        return example;
    }

    public Dataset transform(Dataset dataset) {
        Comparator<Pair> VAL_COMPARATOR = new Comparator<Pair>(){

            @Override
            public int compare(Pair ig1, Pair ig2) {
                if (ig1.value < ig2.value) {
                    return 1;
                }
                if (ig1.value > ig2.value) {
                    return -1;
                }
                return ig1.feature.compareTo(ig2.feature);
            }
        };
        Collections.sort(this.igValues, VAL_COMPARATOR);
        int maxIndex = Math.min(this.igValues.size(), this.TOP_FEATURES);
        HashSet<Feature> availableFeatures = new HashSet<Feature>();
        for (int j = 0; j < maxIndex; ++j) {
            availableFeatures.add(this.igValues.get((int)j).feature);
        }
        BasicDataset maskeDataset = new BasicDataset();
        Iterator<Example> i = dataset.iterator();
        while (i.hasNext()) {
            Example e = i.next();
            MaskedInstance mi = new MaskedInstance(e.asInstance(), availableFeatures);
            Example ex = new Example(mi, e.getLabel());
            maskeDataset.add(ex);
        }
        return maskeDataset;
    }

    public void setNumberOfFeatures(int number) {
        this.TOP_FEATURES = number;
    }

    public void addFeatureIG(double infoGain, Feature f) {
        Pair p = new Pair(infoGain, f);
        this.igValues.add(p);
    }

    public String toString(int top) {
        int maxIndex = Math.min(this.igValues.size(), top);
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < maxIndex; ++j) {
            Feature f = this.igValues.get((int)j).feature;
            double val = this.igValues.get((int)j).value;
            sb.append(f.toString() + " , " + val + "\n");
        }
        return sb.toString();
    }

    private class Pair {
        double value;
        Feature feature;

        public Pair(double v, Feature f) {
            this.value = v;
            this.feature = f;
        }

        public String toString() {
            return "[ " + this.value + "," + this.feature + " ]";
        }
    }
}

