/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.classify.transform.MaskedInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class OrderBasedInstanceTransform
implements InstanceTransform {
    private int TOP_FEATURES = 100;
    private List<Pair> values = new ArrayList<Pair>();

    public Instance transform(Instance instance) {
        System.out.println("Warning: cannot transform instance with Info-Gain!");
        return instance;
    }

    public Example transform(Example example) {
        System.out.println("Warning: cannot transform example with Info-Gain!");
        return example;
    }

    public Dataset transform(Dataset dataset) {
        Comparator<Pair> VAL_COMPARATOR = new Comparator<Pair>(){

            @Override
            public int compare(Pair ig1, Pair ig2) {
                if (ig1.value < ig2.value) {
                    return 1;
                }
                if (ig1.value > ig2.value) {
                    return -1;
                }
                return ig1.feature.compareTo(ig2.feature);
            }
        };
        Collections.sort(this.values, VAL_COMPARATOR);
        int maxIndex = Math.min(this.values.size(), this.TOP_FEATURES);
        HashSet<Feature> availableFeatures = new HashSet<Feature>();
        for (int j = 0; j < maxIndex; ++j) {
            availableFeatures.add(this.values.get((int)j).feature);
        }
        BasicDataset maskeDataset = new BasicDataset();
        Iterator<Example> i = dataset.iterator();
        while (i.hasNext()) {
            Example e = i.next();
            MaskedInstance mi = new MaskedInstance(e.asInstance(), availableFeatures);
            Example ex = new Example(mi, e.getLabel());
            maskeDataset.add(ex);
        }
        return maskeDataset;
    }

    public void setNumberOfFeatures(int number) {
        this.TOP_FEATURES = number;
    }

    public void addFeatureVal(double infoGain, Feature f) {
        Pair p = new Pair(infoGain, f);
        this.values.add(p);
    }

    private class Pair {
        double value;
        Feature feature;

        public Pair(double v, Feature f) {
            this.value = v;
            this.feature = f;
        }

        public String toString() {
            return "[ " + this.value + "," + this.feature + " ]";
        }
    }
}

