/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.transform.AbstractInstanceTransform;
import edu.cmu.minorthird.classify.transform.FeatureReweighter;
import java.util.Iterator;

public class ReweightingInstanceTransform
extends AbstractInstanceTransform {
    private FeatureReweighter reweighter;

    public ReweightingInstanceTransform(FeatureReweighter reweighter) {
        this.reweighter = reweighter;
    }

    public Instance transform(Instance instance) {
        MutableInstance result = new MutableInstance(instance.getSource(), instance.getSubpopulationId());
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            result.addNumeric(f, this.reweighter.reweight(f, instance));
        }
        return result;
    }

    public String toString() {
        return "[ReweightInstTranform " + this.reweighter + "]";
    }
}

