/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.multi.MultiClassLabel;
import edu.cmu.minorthird.classify.multi.MultiClassifier;
import edu.cmu.minorthird.classify.transform.AbstractInstanceTransform;
import edu.cmu.minorthird.classify.transform.TransformingClassifier;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class TransformingMultiClassifier
extends MultiClassifier
implements Visible,
Serializable {
    static final long serialVersionUID = 20080201L;
    private MultiClassifier multiClassifier;
    private AbstractInstanceTransform transformer;

    public TransformingMultiClassifier(MultiClassifier multiClassifier, AbstractInstanceTransform transformer) {
        super(multiClassifier.getClassifiers());
        this.multiClassifier = multiClassifier;
        this.transformer = transformer;
    }

    public AbstractInstanceTransform getTransform() {
        return this.transformer;
    }

    public Classifier[] getClassifiers() {
        Classifier[] tc = new TransformingClassifier[this.multiClassifier.getNumDim()];
        Classifier[] classifiers = this.multiClassifier.getClassifiers();
        for (int i = 0; i < tc.length; ++i) {
            tc[i] = new TransformingClassifier(classifiers[i], this.transformer);
        }
        return tc;
    }

    public MultiClassLabel multiLabelClassification(Instance instance) {
        return super.multiLabelClassification(this.transformer.transform(instance));
    }

    public ClassLabel classification(Instance instance) {
        return super.classification(this.transformer.transform(instance));
    }

    public String explain(Instance instance) {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < this.classifiers.length; ++i) {
            buf.append(this.classifiers[i].explain(instance));
            buf.append("\n");
        }
        buf.append("classification = " + this.classification(instance).toString());
        return buf.toString();
    }

    public Explanation getExplanation(Instance instance) {
        Explanation.Node top = new Explanation.Node("MultiClassifier Explanation");
        Classifier[] classifiers = this.getClassifiers();
        for (int i = 0; i < classifiers.length; ++i) {
            Explanation.Node classEx = classifiers[i].getExplanation(instance).getTopNode();
            top.add(classEx);
        }
        Explanation.Node score = new Explanation.Node("classification = " + this.classification(this.transformer.transform(instance)).toString());
        top.add(score);
        Explanation ex = new Explanation(top);
        return ex;
    }

    public Viewer toGUI() {
        ComponentViewer gui = new ComponentViewer(){
            static final long serialVersionUID = 20080201L;

            public JComponent componentFor(Object o) {
                TransformingMultiClassifier tc = (TransformingMultiClassifier)o;
                JPanel panel = new JPanel();
                panel.setBorder(new TitledBorder("TransformingMultiClassifier"));
                SmartVanillaViewer subview = new SmartVanillaViewer(tc.multiClassifier);
                subview.setSuperView(this);
                panel.add(subview);
                return new JScrollPane(panel);
            }
        };
        gui.setContent(this);
        return gui;
    }
}

