/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.Token;
import java.util.Iterator;

public class BoneheadStemmer {
    public static final String STEM_PROP = "stem";

    public void stem(TextBase base, MonotonicTextLabels labels) {
        Iterator<Span> i = base.documentSpanIterator();
        while (i.hasNext()) {
            Span span = i.next();
            for (int j = 0; j < span.size(); ++j) {
                Token token = span.getToken(j);
                labels.setProperty(token, STEM_PROP, this.stem(token.getValue()));
            }
        }
    }

    public String stem(String s) {
        String lc = s.toLowerCase();
        if (lc.length() < 4) {
            return lc;
        }
        if (lc.endsWith("tion")) {
            return lc.substring(0, lc.length() - 4);
        }
        if (lc.endsWith("ed")) {
            return lc.substring(0, lc.length() - 2);
        }
        if (lc.endsWith("es")) {
            return lc.substring(0, lc.length() - 2);
        }
        if (lc.endsWith("ly")) {
            return lc.substring(0, lc.length() - 2);
        }
        if (lc.endsWith("s")) {
            return lc.substring(0, lc.length() - 1);
        }
        return lc;
    }

    public static void main(String[] args) {
        BoneheadStemmer stemmer = new BoneheadStemmer();
        for (int i = 0; i < args.length; ++i) {
            System.out.println("stem of '" + args[i] + "' = '" + stemmer.stem(args[i]) + "'");
        }
    }
}

