/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import bsh.EvalError;
import bsh.Interpreter;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.MutableTextBase;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.TextBaseLoader;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.learn.SampleClassificationProblem;
import edu.cmu.minorthird.text.learn.SampleExtractionProblem;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class FancyLoader {
    private static Logger log = Logger.getLogger(FancyLoader.class);
    public static final String REPOSITORY_PROP = "edu.cmu.minorthird.repository";
    public static final String DATADIR_PROP = "edu.cmu.minorthird.dataDir";
    public static final String LABELDIR_PROP = "edu.cmu.minorthird.labelDir";
    public static final String SCRIPTDIR_PROP = "edu.cmu.minorthird.scriptDir";
    public static final String SGML_MARKUP_PATTERN_PROP = "edu.cmu.minorthird.sgmlPattern";
    private static Properties props = new Properties();
    private static boolean dataPropertiesFound = false;

    public static Object[] getPossibleTextLabelKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= 3; ++i) {
            result.add("sample" + i + ".train");
            result.add("sample" + i + ".test");
        }
        result.add("sample3.unlabeled");
        File dir = new File(props.getProperty(SCRIPTDIR_PROP));
        if (dir != null) {
            String[] files = dir.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                result.add(files[i]);
            }
        }
        return result.toArray();
    }

    public static TextLabels loadTextLabels(String script) {
        if ("sample1.train".equals(script)) {
            return SampleExtractionProblem.trainLabels();
        }
        if ("sample1.test".equals(script)) {
            return SampleExtractionProblem.testLabels();
        }
        if ("sample2.train".equals(script)) {
            return SampleExtractionProblem.taggerTrainLabels();
        }
        if ("sample2.test".equals(script)) {
            return SampleExtractionProblem.taggerTestLabels();
        }
        if ("sample3.train".equals(script)) {
            return SampleClassificationProblem.trainLabels();
        }
        if ("sample3.test".equals(script)) {
            return SampleClassificationProblem.testLabels();
        }
        if ("sample3.unlabeled".equals(script)) {
            return SampleClassificationProblem.unlabeled();
        }
        String scriptDir = FancyLoader.getProperty(SCRIPTDIR_PROP);
        File f = new File(new File(scriptDir), script);
        if (f.exists() && !f.isDirectory()) {
            log.info("Loading using beanShell script " + f);
            try {
                Object obj = FancyLoader.loadObject(script);
                if (obj != null && obj instanceof TextLabels) {
                    return (TextLabels)obj;
                }
                throw new IllegalArgumentException("script " + script + " from dir " + scriptDir + " returns an invalid object: " + obj);
            }
            catch (EvalError e) {
                log.info("Error running beanShell script " + f + ": " + e);
            }
            catch (IOException e) {
                log.info("Error loading bean shell file " + f + ": " + e);
            }
        }
        File baseFile = new File(script + ".base");
        File baseDir = new File(script);
        boolean sgmlExpected = false;
        System.out.println("The script name is: " + script);
        String pattern = props.getProperty(SGML_MARKUP_PATTERN_PROP);
        try {
            sgmlExpected = Pattern.compile(pattern).matcher(script).matches();
            log.info("Pattern '" + pattern + "' " + (sgmlExpected ? "does" : "does not") + " match '" + script + "' so SGML markup " + (sgmlExpected ? "is" : "is not") + " expected in documents");
        }
        catch (PatternSyntaxException ex) {
            log.error("can't match illegal edu.cmu.minorthird.sgmlPattern regex: " + pattern);
        }
        try {
            File mixupFile;
            MutableTextBase base = null;
            TextBaseLoader tbl = null;
            if (baseDir.exists() && baseDir.isDirectory()) {
                log.info("Loading documents from files in directory " + baseDir);
                tbl = new TextBaseLoader(1, sgmlExpected);
                try {
                    base = tbl.load(baseDir);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (baseFile.exists()) {
                log.info("Loading documents from lines in file " + baseFile);
                tbl = new TextBaseLoader(0, sgmlExpected);
                try {
                    base = tbl.load(baseFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (base == null) {
                log.info("Expected to find beanShell script in " + scriptDir + "/" + script + " or else a file named '" + baseFile + "' or a directory named '" + baseDir + "'");
                log.error("Can't find documents for key '" + script + "'");
                return null;
            }
            MonotonicTextLabels labels = sgmlExpected ? tbl.getLabels() : new BasicTextLabels(base);
            File labelFile = new File(script + ".labels");
            if (labelFile.exists()) {
                log.info("Loading annotations from " + labelFile);
                new TextLabelsLoader().importOps((MutableTextLabels)labels, base, labelFile);
            }
            if ((mixupFile = new File(script + ".mixup")).exists()) {
                log.info("Adding annotations with " + mixupFile);
                MixupInterpreter interp = new MixupInterpreter(new MixupProgram(mixupFile));
                interp.eval(labels);
                labels = interp.getCurrentLabels();
            }
            return labels;
        }
        catch (IOException ex) {
            log.error("IO error loading '" + script + "': " + ex);
        }
        catch (Mixup.ParseException ex) {
            log.error("Mixup error loading '" + script + "': " + ex);
        }
        log.error("no data found for key: " + script);
        return null;
    }

    private static Object loadObject(String script) throws EvalError, IOException {
        String dataDir = FancyLoader.getProperty(DATADIR_PROP);
        String labelDir = FancyLoader.getProperty(LABELDIR_PROP);
        String scriptDir = FancyLoader.getProperty(SCRIPTDIR_PROP);
        log.debug("loading with dataDir: " + dataDir + " labelDir: " + labelDir + " scriptDir: " + scriptDir);
        File f = new File(new File(scriptDir), script);
        if (!f.exists()) {
            throw new IllegalArgumentException("can't find file " + f.getAbsolutePath());
        }
        log.debug("loading object defined by " + f.getAbsolutePath());
        Interpreter interpreter = new Interpreter();
        interpreter.set("dataDir", new File(dataDir));
        interpreter.set("labelDir", new File(labelDir));
        return interpreter.source(f.getAbsolutePath());
    }

    public static String getProperty(String prop) {
        String v = System.getProperty(prop);
        return v != null ? v : props.getProperty(prop);
    }

    public static void main(String[] args) throws EvalError, IOException {
        Object o = FancyLoader.loadObject(args[0]);
        System.out.println("loaded " + o);
        if (o instanceof TextLabels) {
            TextBaseViewer.view((TextLabels)o);
        }
    }

    static {
        try {
            InputStream in = FancyLoader.class.getClassLoader().getResourceAsStream("data.properties");
            if (in != null) {
                props.load(in);
                log.debug("loaded properties from stream " + in);
                dataPropertiesFound = true;
            } else {
                log.info("no data.properties found on classpath");
                dataPropertiesFound = false;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("error getting data.properties: " + e);
        }
        String[] ps = new String[]{REPOSITORY_PROP, DATADIR_PROP, LABELDIR_PROP, SCRIPTDIR_PROP, SGML_MARKUP_PATTERN_PROP};
        for (int i = 0; i < ps.length; ++i) {
            if (System.getProperty(ps[i]) == null) continue;
            props.setProperty(ps[i], System.getProperty(ps[i]));
        }
        String defaultRepositoryValue = System.getProperty(REPOSITORY_PROP, ".");
        String defaultSGMLPattern = System.getProperty(SGML_MARKUP_PATTERN_PROP, ".*");
        if (dataPropertiesFound) {
            if (props.getProperty(REPOSITORY_PROP) == null) {
                props.setProperty(REPOSITORY_PROP, defaultRepositoryValue);
            }
            if (props.getProperty(DATADIR_PROP) == null) {
                props.setProperty(DATADIR_PROP, props.getProperty(REPOSITORY_PROP) + "/data");
            }
            if (props.getProperty(LABELDIR_PROP) == null) {
                props.setProperty(LABELDIR_PROP, props.getProperty(REPOSITORY_PROP) + "/labels");
            }
            if (props.getProperty(SCRIPTDIR_PROP) == null) {
                props.setProperty(SCRIPTDIR_PROP, props.getProperty(REPOSITORY_PROP) + "/loaders");
            }
            if (props.getProperty(SGML_MARKUP_PATTERN_PROP) == null) {
                props.setProperty(SGML_MARKUP_PATTERN_PROP, defaultSGMLPattern);
            }
        } else {
            props.setProperty(SGML_MARKUP_PATTERN_PROP, defaultSGMLPattern);
            props.setProperty(DATADIR_PROP, defaultRepositoryValue);
            props.setProperty(LABELDIR_PROP, defaultRepositoryValue);
            props.setProperty(SCRIPTDIR_PROP, defaultRepositoryValue);
        }
        log.info("dataDir:   " + props.getProperty(DATADIR_PROP));
        log.info("labelDir:  " + props.getProperty(LABELDIR_PROP));
        log.info("scriptDir: " + props.getProperty(SCRIPTDIR_PROP));
        log.info("expect SGML in files matching '" + props.getProperty(SGML_MARKUP_PATTERN_PROP) + "'");
    }
}

